package com.jugg.agile.spring.boot.webmvc.context.link;

import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.webmvc.context.JaWebContextLink;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 服务信息的链路传递
 *
 * @author chenjian
 * @since 2023年04月02日 18:35:00
 */
public class RemoteAddrContextLink implements JaWebContextLink<JaCoreContextEntity> {
    @Override
    public void inherit(HttpServletRequest source, JaCoreContextEntity target) {
        String sIp = source.getHeader(JaCoreContextEntity.HeaderSourceIp);
        if (JaStringUtil.isEmpty(sIp)) {
            sIp = JaServletUtil.getRemoteAddr(source);
        }
        if (JaStringUtil.isNotEmpty(sIp)) {
            target.setSIp(sIp);
        }

        String usIp = source.getHeader(JaCoreContextEntity.HeaderUpstreamServerIP);
        if (JaStringUtil.isEmpty(usIp)) {
            usIp = JaServletUtil.getRemoteAddr(source);
        }
        if (JaStringUtil.isNotEmpty(usIp)) {
            target.setUsIp(usIp);
        }
    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        // Do nothing
    }

}
