/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.webmvc;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.net.JaIPUtil;
import com.jugg.agile.spring.boot.webmvc.servlet.JaServletConfig;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@ConditionalOnProperty(value={"springfox.documentation.enabled"}, havingValue="true", matchIfMissing=true)
public class JaSwaggerConfiguration {
    @Bean
    public Docket docket() {
        String basePackage = JaProperty.get((String)"ja.swagger.basePackage");
        if (JaStringUtil.isEmpty((String)basePackage)) {
            JaLog.warn((String)"ja swagger init error, basePackage isEmpty", (Object[])new Object[0]);
            return null;
        }
        String contextPath = JaServletUtil.getContextPath();
        JaServletConfig.getPassUrlSet().add(contextPath + "doc.html");
        JaServletConfig.getPassUrlSet().add(contextPath + "favicon.ico");
        JaServletConfig.getPassUrlSet().add(contextPath + "swagger-resources");
        JaServletConfig.getPassUrlSet().add(contextPath + "v2/api-docs");
        JaServletConfig.getPassUrlSet().add(contextPath + "webjars");
        String version = JaEnvProperty.getVersion();
        if (JaStringUtil.isEmpty((String)version)) {
            version = "local";
        }
        JaLog.info((String)"swagger2 knife4j : {}", (Object[])new Object[]{String.format("http://%s:%s%sdoc.html#/home", JaIPUtil.getLocalIP(), JaServletUtil.getPort(), contextPath)});
        return new Docket(DocumentationType.SWAGGER_2).enable(!JaEnvProperty.isCD()).apiInfo(new ApiInfoBuilder().version(JaProperty.get((String)"ja.swagger.version", (String)version)).title(JaProperty.get((String)"ja.swagger.title", (String)JaEnvProperty.getApplicationName())).description(JaProperty.get((String)"ja.swagger.description", (String)"swagger2\u63a5\u53e3")).termsOfServiceUrl(JaProperty.get((String)"ja.swagger.termsOfServiceUrl", (String)contextPath)).contact(new Contact(JaProperty.get((String)"ja.swagger.author", (String)"jugg"), "url", null)).build()).groupName(JaProperty.get((String)"ja.swagger.groupName", (String)"groupName")).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any()).build();
    }

    @ConditionalOnBean(value={WebMvcConfigurationSupport.class})
    @ConditionalOnProperty(value={"springfox.documentation.enabled"}, havingValue="true", matchIfMissing=true)
    public static class JaSwaggerWebMvcConfigurationSupport
    extends WebMvcConfigurationSupport {
        protected void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/doc.html"}).addResourceLocations(new String[]{"classpath*:/META-INF/resources/"});
            registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath*:/META-INF/resources/webjars/"});
        }
    }
}

