package com.jugg.agile.spring.boot.webmvc;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.io.net.JaIPUtil;
import com.jugg.agile.spring.boot.webmvc.servlet.JaServletConfig;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnWebApplication
@ConditionalOnMissingBean(Docket.class)
public class JaSwaggerConfiguration {
    @Bean
    public Docket docket() {
        if (JaEnvProperty.isCD() && JaEnvProperty.getEnv().contains("prod")) {
            return null;
        }
        String basePackage = JaProperty.get("ja.swagger.basePackage");
        if (JaStringUtil.isEmpty(basePackage)) {
            JaLog.warn("ja swagger init error, basePackage isEmpty");
            return null;
        }
        String contextPath = JaServletUtil.getContextPath();
        JaServletConfig.getPassUrlSet().add(contextPath + "doc.html");
        JaServletConfig.getPassUrlSet().add(contextPath + "favicon.ico");
        JaServletConfig.getPassUrlSet().add(contextPath + "swagger-resources");
        JaServletConfig.getPassUrlSet().add(contextPath + "v2/api-docs");

        String version = JaEnvProperty.getVersion();
        if (JaStringUtil.isEmpty(version)) {
            version = "local";
        }
        JaLog.info("swagger2 knife4j : {}", String.format("http://%s:%s%sdoc.html#/home"
                , JaIPUtil.getLocalIP()
                , JaServletUtil.getPort()
                , contextPath
                )
        );
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(new ApiInfoBuilder()
                        .version(JaProperty.get("ja.swagger.version", version))
                        .title(JaProperty.get("ja.swagger.title", "接口文档"))
                        .description(JaProperty.get("ja.swagger.description", "swagger2接口"))
                        .termsOfServiceUrl(JaProperty.get("ja.swagger.termsOfServiceUrl", contextPath))
                        .contact(new Contact(JaProperty.get("ja.swagger.author", "jugg")
                                , "url"
                                , null))
                        .build())
                .groupName(JaProperty.get("ja.swagger.groupName", "groupName"))
                .select()
                .apis(RequestHandlerSelectors.basePackage(basePackage))
                .paths(PathSelectors.any())
                .build();
    }
}
