package com.jugg.agile.spring.boot.webmvc.context;


import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.context.JaMapTargetContextChain;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * web 链路
 * 注意 : tomcat获取head效率低
 *
 * @author chenjian
 * @see org.apache.tomcat.util.http.MimeHeaders#getValue(java.lang.String)
 * @since 2023年03月10日 11:55:25
 */
@SuppressWarnings({"rawtypes"})
public class JaWebContextChain extends JaMapTargetContextChain<HttpServletRequest, JaWebContextLink> {

    private JaWebContextChain() {
    }

    @Override
    public void inherit(HttpServletRequest s) {
        JaMapContextChain.getInstance().inherit(JaServletUtil.getAllHeaders(s));
        super.inherit(s);
    }

    @Override
    public void removeChain() {
        JaMapContextChain.getInstance().remove();
    }

    @Override
    public Map<String, String> transmit() {
        Map<String, String> transmit = JaMapContextChain.getInstance().transmit();
        transmit.putAll(super.transmit());
        return transmit;
    }

    public static JaWebContextChain getInstance() {
        return Instance.instance;
    }

    private static class Instance {
        private static final JaWebContextChain instance = new JaWebContextChain();
    }
}
