package com.jugg.agile.spring.boot.webmvc.util;

import com.jugg.agile.framework.core.util.JaStringUtil;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JaSpringExecptionUtil {

    public static void demo(MethodArgumentNotValidException e) {
        List<ObjectError> allErrors = e.getBindingResult().getAllErrors();
        Set<String> set = new HashSet<>();
        allErrors.forEach(objectError -> {
            String defaultMessage = objectError.getDefaultMessage();
            if (JaStringUtil.isNotEmpty(defaultMessage)) {
                if (defaultMessage.startsWith("{")) {
                    defaultMessage = defaultMessage.substring(1, defaultMessage.length() - 1);
                }
                set.add(defaultMessage);
            }
        });
        StringBuilder message = new StringBuilder();
        StringBuilder errorLog = new StringBuilder();
    }
}
