package com.jugg.agile.spring.boot.webmvc.util;

import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;

public class JaSpringServletUtil {

    private JaSpringServletUtil() {
    }

    private static final JaThreadLocal<HttpServletRequest> httpServletRequestThreadLocal = new JaThreadLocal<>();

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest httpServletRequest = httpServletRequestThreadLocal.get();
        if (null != httpServletRequest) {
            return httpServletRequest;
        }

        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null == requestAttributes) {
            return null;
        }
        Object resolveReference = requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
        if (null == resolveReference) {
            return null;
        }
        return (HttpServletRequest) resolveReference;
    }

    public static String getUserAgent() {
        return JaServletUtil.getUserAgent(getHttpServletRequest());
    }

    public static JaThreadLocal<HttpServletRequest> getHttpServletRequestThreadLocal() {
        return httpServletRequestThreadLocal;
    }

}
