/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.webmvc.servlet;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.context.biz.JaCoreContext;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarm;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarmMessage;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarmWebhook;
import com.jugg.agile.framework.core.dapper.alarm.adapter.qywx.JaQyWxAlarm;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.JaThrowableUtil;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import com.jugg.agile.framework.meta.dto.JaResultDTO;
import com.jugg.agile.framework.meta.exception.JaException;
import com.jugg.agile.spring.boot.webmvc.context.JaWebContextChain;
import com.jugg.agile.spring.boot.webmvc.servlet.JaServletConfig;
import com.jugg.agile.spring.boot.webmvc.util.JaServletUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class JaServletFilter
implements Filter {
    private static final String logFormatEntry = "url:[{} - {}][ja_ms:{}] - [{}]";
    private static long servletConnNums;
    private static boolean servletConnNumsStop;
    private static boolean checkUnknownUpServer;
    private static final JaQyWxAlarm alarmUnknownUpServer;
    private static final HashSet<String> unknownUpServerIPSet;
    private static final AtomicInteger Connections;

    public void init(FilterConfig filterConfig) {
        JaWebContextChain instance = JaWebContextChain.getInstance();
        JaLog.info((String)"JaServletFilter init:{}", (Object[])new Object[]{instance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) {
        int connNums = Connections.incrementAndGet();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = request.getRequestURI();
        try {
            this.wrapDapper(request, response);
            if (JaServletConfig.isPass(requestURI)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            JaLog.info((String)logFormatEntry, (Object[])new Object[]{requestURI, connNums, JaCoreContextEntity.getsReqMS(), JaJson.toString((Object)JaCoreContext.getInstance().get())});
            this.checkUpServer(request);
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable e) {
            JaServletFilter.handleException(request, response, e);
        }
        finally {
            JaWebContextChain.getInstance().remove();
            Connections.decrementAndGet();
        }
    }

    public void destroy() {
        JaAlarmWebhook.ScheduledThreadPoolExecutor.shutdownNow();
        JaLog.info((String)"JaServletFilter destroy", (Object[])new Object[0]);
    }

    protected static void handleException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        JaLog.get().error("http filter catch ex", e);
        e = JaThrowableUtil.getCause((Throwable)e);
        String code = null;
        String codeMsg = null;
        if (e instanceof JaException) {
            code = ((JaException)e).getCode();
        }
        codeMsg = String.format("Unknown Error:[%s]-[%s]", request.getRequestURI(), JaMDC.get());
        JaResultDTO result = new JaResultDTO();
        result.setCode(code);
        result.setCodeMsg(codeMsg);
        response.setStatus(HttpStatus.HTTP_VERSION_NOT_SUPPORTED.value());
        JaServletUtil.printResponse(request, response, result);
    }

    private void alarm(int connNums) {
        if (servletConnNumsStop && (long)connNums > servletConnNums) {
            try {
                String error = String.format("servlet current thread : %s > %s", connNums, servletConnNums);
                JaLog.info((String)error, (Object[])new Object[0]);
                JaFunctionP alarmHandler = JaAlarm.getAlarmHandler();
                if (null != alarmHandler) {
                    alarmHandler.apply((Object)(JaAlarmMessage.getCommonMessage() + error));
                }
            }
            catch (Throwable e) {
                JaLog.error((String)"servlet connection nums alarm error", (Object[])new Object[]{e});
            }
        }
        Connections.decrementAndGet();
    }

    private void wrapDapper(HttpServletRequest request, HttpServletResponse response) {
        JaWebContextChain.getInstance().inherit(request);
        request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (JaStringUtil.isEmpty((String)response.getHeader(JaMDC.TraceId))) {
            response.setHeader("Access-Control-Expose-Headers", JaMDC.TraceId);
            response.addHeader(JaMDC.TraceId, JaMDC.get());
        }
    }

    private void checkUpServer(HttpServletRequest request) {
        JaCoreContextEntity jaCoreContextEntity = JaCoreContext.getInstance().get();
        String usIp = jaCoreContextEntity.getUsIp();
        if (checkUnknownUpServer && JaStringUtil.isEmpty((String)jaCoreContextEntity.getUsName()) && JaStringUtil.isNotEmpty((String)usIp) && !JaServletUtil.isFromWeb(request) && !unknownUpServerIPSet.contains(usIp)) {
            alarmUnknownUpServer.alarm(JaAlarmMessage.getCommonMessage() + "\u672a\u77e5\u6765\u6e90IP:" + jaCoreContextEntity.getUsIp());
            unknownUpServerIPSet.add(jaCoreContextEntity.getUsIp());
            if (unknownUpServerIPSet.size() > 10000) {
                alarmUnknownUpServer.alarm(JaAlarmMessage.getCommonMessage() + "\u672a\u77e5\u6765\u6e90IP\u6570\u6e05\u7a7a\u7f13\u5b58");
                unknownUpServerIPSet.clear();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }

    static {
        unknownUpServerIPSet = new HashSet();
        Connections = new AtomicInteger();
        alarmUnknownUpServer = new JaQyWxAlarm("checkUpServer");
        alarmUnknownUpServer.setUrl("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=c8e9019c-fb68-4281-ba47-690be69fb47a");
        JaPropertyListener.addAndRunCommonListener(() -> {
            checkUnknownUpServer = JaProperty.getBoolean((String)"ja.servlet.checkUnknownUpServer", (Boolean)false);
        });
    }
}

