package com.jugg.agile.spring.boot.core.context;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.Locale;
import java.util.Map;

public class JaAcceptLanguageContextLink implements JaMapContextLink<JaCoreContextEntity> {

    @Override
    public void inherit(Map<String, String> source, JaCoreContextEntity context) {
        if (null == JaI18nUtil.LocaleThreadLocal.get()) {
            String acceptLanguage = source.get(JaI18nUtil.Header);
            if (JaStringUtil.isEmpty(acceptLanguage)) {
                acceptLanguage = source.get(JaI18nUtil.HeaderUp);
            }

            if (JaStringUtil.isNotEmpty(acceptLanguage)) {
                Locale locale = JaI18nUtil.parseLocales(acceptLanguage);
                JaI18nUtil.LocaleThreadLocal.set(locale);
                LocaleContextHolder.setLocale(locale);
            }
        }

    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        Locale locale = JaI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            // zh-CN
            transmit(target, JaI18nUtil.Header, locale.toLanguageTag());
        }

    }

    @Override
    public void remove() {
        JaI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }
}
