package com.jugg.agile.spring.boot.core.context;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaSpringI18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.Locale;
import java.util.Map;

public class JaAcceptLanguageContextLink implements JaMapContextLink<JaCoreContextEntity> {

    @Override
    public void inherit(Map<String, String> source, JaCoreContextEntity context) {
        if (null == JaSpringI18nUtil.LocaleThreadLocal.get()) {
            String acceptLanguage = source.get(JaSpringI18nUtil.Header);
            if (JaStringUtil.isEmpty(acceptLanguage)) {
                acceptLanguage = source.get(JaSpringI18nUtil.HeaderUp);
            }

            if (JaStringUtil.isNotEmpty(acceptLanguage)) {
                Locale locale = JaSpringI18nUtil.parseLocales(acceptLanguage);
                JaSpringI18nUtil.LocaleThreadLocal.set(locale);
                LocaleContextHolder.setLocale(locale);
            }
        }

    }

    @Override
    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        Locale locale = JaSpringI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            // zh-CN
            transmit(target, JaSpringI18nUtil.Header, locale.toLanguageTag());
        }

    }

    @Override
    public void remove() {
        JaSpringI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }
}
