package com.jugg.agile.spring.boot.dapper.node;

import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
@ConditionalOnClass(name = {"org.mybatis.spring.annotation.MapperScan", JaNodeSpanMybatisPlus.ProxyClassName})
public class JaNodeSpanMybatisPlus implements JaNodeSpanResolver {
    public static final String ProxyClassName = "com.baomidou.mybatisplus.core.override.MybatisMapperProxy";
    private static final String mybatisPlus = "com.baomidou";
    private static final NodeKind mybatisPlusNodeKind = new NodeKind("db")
            .buildReqArgsHandler(args -> {
                if (JaCollectionUtil.isEmpty(args)) {
                    return args;
                }
                ArrayList<Object> objects = new ArrayList<>(args.length);
                for (Object arg : args) {
                    if (null != arg && arg.getClass().getName().startsWith(mybatisPlus)) {
                        continue;
                    }
                    objects.add(arg);
                }
                return objects.toArray();
            });

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (invocation instanceof ReflectiveMethodInvocation) {
            Object proxy = ((ReflectiveMethodInvocation) invocation).getProxy();
            if (proxy.toString().startsWith(mybatisPlus)) {
                return get(mybatisPlusNodeKind);
            }
        }
        return null;
    }
}
