/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.core.config;

import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaEnvPropertyHandler;
import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaPrePropertyHandler;
import com.jugg.agile.framework.core.config.JaPropertyHandler;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.config.JaSpringProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.core.JaSpringApplicationRunListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class JaEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!JaSpringBootUtil.isCloudContainer()) {
            JaSpringBootUtil.setEnvironment(environment);
            JaSpringProperty.setEnvironmentHandler(arg_0 -> ((ConfigurableEnvironment)environment).getProperty(arg_0));
            JaSpringPropertyProcessor.loadLocalConfig(environment);
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaEnvPropertyHandler.class);
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaPrePropertyHandler.class);
            if (JaEnvProperty.useCenter() && !JaEnvProperty.priorityCenter()) {
                JaPropertyHandler.Processor.loadJaPropertyHandler(JaCenterPropertyHandler.class);
            }
            JaSpringPropertyProcessor.loadLocalConfig(environment);
            if (JaEnvProperty.useCenter() && JaEnvProperty.priorityCenter()) {
                JaPropertyHandler.Processor.loadJaPropertyHandler(JaCenterPropertyHandler.class);
            }
            JaPropertyHandler.Processor.loadJaPropertyHandler(JaPostPropertyHandler.class);
            String env = JaEnvProperty.getEnv();
            if (JaStringUtil.isNotEmpty((String)env)) {
                environment.setActiveProfiles(new String[]{env});
            }
            JaSpringPropertyProcessor.setEnvironment(environment, "jaProperties");
            JaPropertyListener.executeCommonListener();
            JaPropertyListener.executeBizListener();
            JaSpringPropertyProcessor.outputFinalConfig(environment);
            JaSpringApplicationRunListener.environmentPrepared();
        }
    }

    public int getOrder() {
        return 0;
    }
}

