package com.jugg.agile.spring.boot.core.context;

import com.jugg.agile.framework.core.context.JaContext;
import com.jugg.agile.framework.core.util.JaSpiUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.spring.util.JaSpringClassUtil;
import org.springframework.core.type.classreading.MetadataReader;

import java.util.HashSet;
import java.util.Set;

public class JaContextProcessor {
    private JaContextProcessor() {

    }

    public static void init() {
        Set<MetadataReader> readableResource = new HashSet<>();
        JaSpiUtil.getCustomBasePackageSet().forEach(s -> readableResource.addAll(JaSpringClassUtil.getReadableResource(s)));

        String name = JaContext.class.getName();
        readableResource.forEach(metadataReader -> {
            if (name.equals(metadataReader.getClassMetadata().getSuperClassName())) {
                JaClassUtil.load(JaSpringClassUtil.getClassPath(metadataReader));
            }
        });
    }
}
