/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.core.context;

import com.jugg.agile.framework.core.context.JaMapContextLink;
import com.jugg.agile.framework.core.context.biz.JaCoreContextEntity;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class JaAcceptLanguageContextLink
implements JaMapContextLink<JaCoreContextEntity> {
    public void inherit(Map<String, String> source, JaCoreContextEntity context) {
        if (null == JaI18nUtil.LocaleThreadLocal.get()) {
            String acceptLanguage = source.get("accept-language");
            if (JaStringUtil.isEmpty((String)acceptLanguage)) {
                acceptLanguage = source.get("Accept-Language");
            }
            if (JaStringUtil.isNotEmpty((String)acceptLanguage)) {
                Locale locale = JaI18nUtil.parseLocales(acceptLanguage);
                JaI18nUtil.LocaleThreadLocal.set((Object)locale);
                LocaleContextHolder.setLocale((Locale)locale);
            }
        }
    }

    public void transmit(JaCoreContextEntity source, Map<String, String> target) {
        Locale locale = (Locale)JaI18nUtil.LocaleThreadLocal.get();
        if (null != locale) {
            this.transmit(target, "accept-language", locale.toLanguageTag());
        }
    }

    public void remove() {
        JaI18nUtil.LocaleThreadLocal.remove();
        LocaleContextHolder.resetLocaleContext();
    }
}

