/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.dapper.node;

import com.jugg.agile.framework.core.context.JaMapContextChain;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
public class JaNodeSpanRestTemplate
implements JaNodeSpanResolver,
JaDapperAspectPointcut,
ClientHttpRequestInterceptor {
    public static final String ProxyClassName = "org.springframework.web.client.RestTemplate";

    private static void initNodeKind() {
        NodeKind.Constant.RestTemplate.buildResponseHandler(o -> o instanceof ResponseEntity ? ((ResponseEntity)o).getBody() : o).buildIdHandler(invocation -> {
            Object[] arguments = invocation.getArguments();
            if (JaCollectionUtil.isNotEmpty((Object[])arguments)) {
                Object argument = arguments[0];
                if (argument instanceof String || argument instanceof URI) {
                    return argument.toString();
                }
                if (argument instanceof RequestEntity) {
                    return ((RequestEntity)argument).getUrl().toString();
                }
            }
            return invocation.getMethod().hashCode() + "";
        }).buildReqArgsHandler(args -> {
            if (JaCollectionUtil.isEmpty((Object[])args)) {
                return args;
            }
            ArrayList<Object> objects = new ArrayList<Object>(((Object[])args).length);
            for (Object arg : args) {
                if (arg instanceof String || arg instanceof URI || arg instanceof HttpMethod || arg instanceof Type || arg instanceof ParameterizedTypeReference) continue;
                if (arg instanceof HttpEntity) {
                    objects.add(((HttpEntity)arg).getBody());
                    continue;
                }
                objects.add(arg);
            }
            return objects.toArray();
        }).buildRequestIdThreadLocal();
    }

    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        Object proxy;
        if (invocation instanceof ReflectiveMethodInvocation && (proxy = ((ReflectiveMethodInvocation)invocation).getProxy()).toString().startsWith(ProxyClassName)) {
            return this.get(NodeKind.Constant.RestTemplate);
        }
        return null;
    }

    public String getExpression() {
        return "execution(* org.springframework.web.client.RestOperations.*(..))";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            HttpHeaders headers = request.getHeaders();
            JaMapContextChain.getInstance().transmit().forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
            String requestId = (String)NodeKind.Constant.RestTemplate.getRequestIdThreadLocal().get();
            if (null != requestId) {
                headers.add(JaMDC.RequestId, requestId);
            }
            ClientHttpResponse clientHttpResponse = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            NodeKind.Constant.RestTemplate.getRequestIdThreadLocal().remove();
        }
    }

    public void initNodeSpanResolver() {
        List beanList = JaSpringBeanUtil.getBeanList(RestTemplate.class);
        if (JaCollectionUtil.isNotEmpty((Collection)beanList)) {
            beanList.forEach(restTemplate -> ((RestTemplate)JaSpringAopUtil.getSingletonTarget((Object)restTemplate)).getInterceptors().add(0, this));
        } else {
            JaLog.warn((String)"JaNodeSpanRestTemplate add interceptor error : restTemplate is null", (Object[])new Object[0]);
        }
    }

    static {
        JaNodeSpanRestTemplate.initNodeKind();
    }
}

