package com.jugg.agile.spring.boot.core.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import com.jugg.agile.spring.util.JaSpringContextUtil;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class JaSpringPropertyProcessor {

    private static final Properties jaProperties = new Properties();

    private JaSpringPropertyProcessor() {
    }

    // org.springframework.boot.context.config.ConfigFileApplicationListener.Loader.load(org.springframework.boot.env.PropertySourceLoader, java.lang.String, org.springframework.boot.context.config.ConfigFileApplicationListener.Profile, org.springframework.boot.context.config.ConfigFileApplicationListener.DocumentFilter, org.springframework.boot.context.config.ConfigFileApplicationListener.DocumentConsumer)
    private static final String LoadPropertySourcePre = "applicationConfig: ";

    /**
     * JaProperty加载到Environment
     */
    public static synchronized void setEnvironment(ConfigurableEnvironment environment, String name) {
        MutablePropertySources propertySources = getMutablePropertySources(environment);
        if (null != propertySources) {
            String relativePropertySourceName = null;
            for (PropertySource<?> propertySource : propertySources) {
                if (null != propertySource && propertySource.getName().startsWith(LoadPropertySourcePre)) {
                    relativePropertySourceName = propertySource.getName();
                    break;
                }
            }

            JaProperty.getPropertyMap().forEach(jaProperties::put);
            if (null == relativePropertySourceName) {
                propertySources.addLast(new PropertiesPropertySource(name, jaProperties));
            } else {
                propertySources.addBefore(relativePropertySourceName, new PropertiesPropertySource(name, jaProperties));
            }
        }
    }

    /**
     * 最终使用配置输出
     */
    @SuppressWarnings({"unchecked"})
    public static void outputFinalConfig(ConfigurableEnvironment environment) {
        if (JaEnvProperty.isCD() || Boolean.TRUE.equals(JaProperty.getBoolean("ja.config.output", false))) {
            try (FileOutputStream outputStream = new FileOutputStream("jugg.properties")) {

                Map<String, Object> map = new TreeMap<>();
                MutablePropertySources propertySources = getMutablePropertySources(environment);
                if (null != propertySources) {
                    propertySources = environment.getPropertySources();
                    ArrayList<Map<String, Object>> allPropertySourcesList = new ArrayList<>();
                    propertySources.forEach(propertySource -> {
                        Object source = propertySource.getSource();
                        if (source instanceof Map) {
                            Map<String, Object> sourceMap = (Map<String, Object>) source;
                            if (JaCollectionUtil.isNotEmpty(sourceMap)) {
                                allPropertySourcesList.add(sourceMap);
                            }
                        } else {
                            JaLog.info("unknown propertySource, name:{}", propertySource.getName());
                        }

                    });

                    if (JaCollectionUtil.isNotEmpty(allPropertySourcesList)) {
                        for (int i = allPropertySourcesList.size() - 1; i >= 0; i--) {
                            allPropertySourcesList.get(i).forEach((s, o) -> map.put(s, o.toString()));
                        }
                    }
                }

                Properties properties = new Properties();
                properties.putAll(map);
                properties.store(outputStream, null);
            } catch (Throwable e) {
                JaLog.warn("final.properties store error:{}", e);
            }
        }
    }

    /**
     * 刷新配置
     */
    public static <T> void refresh(Class<T> configBeanClass) {
        JaProperty.getPropertyMap().forEach(jaProperties::put);
        T targetConfigBean = JaSpringBeanUtil.getBean(configBeanClass);
        ConfigurationPropertiesBindingPostProcessor bindingPostProcessor = JaSpringBeanUtil.getBean(ConfigurationPropertiesBindingPostProcessor.class);
        assert bindingPostProcessor != null;
        assert targetConfigBean != null;
        String[] beanNamesForType = JaSpringContextUtil.getApplicationContext().getBeanNamesForType(configBeanClass);
        if (JaCollectionUtil.isNotEmpty(beanNamesForType)) {
            String beanName = beanNamesForType[0];
            bindingPostProcessor.postProcessBeforeInitialization(targetConfigBean, beanName);
        } else {
            JaLog.warn("{} config refresh error", configBeanClass.getName());
        }
    }

    /**
     * 读取Spring配置到JaProperty
     */
    @SuppressWarnings({"unchecked"})
    public static synchronized void loadLocalConfig(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = getMutablePropertySources(environment);
        if (null != propertySources) {
            propertySources = environment.getPropertySources();
            ArrayList<Map<String, Object>> applicationConfigPropertySourcesList = new ArrayList<>();
            propertySources.forEach(propertySource -> {
                if (null != propertySource && propertySource.getName().startsWith(LoadPropertySourcePre)) {
                    Object source = propertySource.getSource();
                    if (source instanceof Map) {
                        Map<String, Object> sourceMap = (Map<String, Object>) source;
                        if (JaCollectionUtil.isNotEmpty(sourceMap)) {
                            applicationConfigPropertySourcesList.add(sourceMap);
                        }
                    } else {
                        JaLog.info("unknown propertySource, name:{}", propertySource.getName());
                    }
                }

            });

            if (JaCollectionUtil.isNotEmpty(applicationConfigPropertySourcesList)) {
                for (int i = applicationConfigPropertySourcesList.size() - 1; i >= 0; i--) {
                    applicationConfigPropertySourcesList.get(i).forEach((s, o) -> JaProperty.put(s, o.toString()));
                }
            }
        }
    }

    public static MutablePropertySources getMutablePropertySources(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = null;
        if (environment instanceof AbstractEnvironment) {
            propertySources = environment.getPropertySources();
        } else {
            JaLog.get().warn("not support this environment{}", environment.getClass().getName());
        }
        return propertySources;
    }
}
