/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.core.config;

import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import com.jugg.agile.spring.util.JaSpringContextUtil;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class JaSpringPropertyProcessor {
    private static final Properties jaProperties = new Properties();
    private static final String LoadPropertySourcePre = "applicationConfig: ";

    private JaSpringPropertyProcessor() {
    }

    public static synchronized void setEnvironment(ConfigurableEnvironment environment, String name) {
        MutablePropertySources propertySources = JaSpringPropertyProcessor.getMutablePropertySources(environment);
        if (null != propertySources) {
            String relativePropertySourceName = null;
            for (PropertySource propertySource : propertySources) {
                if (null == propertySource || !propertySource.getName().startsWith(LoadPropertySourcePre)) continue;
                relativePropertySourceName = propertySource.getName();
                break;
            }
            JaProperty.getPropertyMap().forEach(jaProperties::put);
            if (null == relativePropertySourceName) {
                propertySources.addLast((PropertySource)new PropertiesPropertySource(name, jaProperties));
            } else {
                propertySources.addBefore(relativePropertySourceName, (PropertySource)new PropertiesPropertySource(name, jaProperties));
            }
        }
    }

    public static void outputFinalConfig(ConfigurableEnvironment environment) {
        if (JaEnvProperty.isCD() || Boolean.TRUE.equals(JaProperty.getBoolean((String)"ja.config.output", (Boolean)false))) {
            try (FileOutputStream outputStream = new FileOutputStream("jugg.properties");){
                TreeMap map = new TreeMap();
                MutablePropertySources propertySources = JaSpringPropertyProcessor.getMutablePropertySources(environment);
                if (null != propertySources) {
                    propertySources = environment.getPropertySources();
                    ArrayList allPropertySourcesList = new ArrayList();
                    propertySources.forEach(propertySource -> {
                        Object source = propertySource.getSource();
                        if (source instanceof Map) {
                            Map sourceMap = (Map)source;
                            if (JaCollectionUtil.isNotEmpty((Map)sourceMap)) {
                                allPropertySourcesList.add(sourceMap);
                            }
                        } else {
                            JaLog.info((String)"unknown propertySource, name:{}", (Object[])new Object[]{propertySource.getName()});
                        }
                    });
                    if (JaCollectionUtil.isNotEmpty(allPropertySourcesList)) {
                        for (int i = allPropertySourcesList.size() - 1; i >= 0; --i) {
                            ((Map)allPropertySourcesList.get(i)).forEach((s, o) -> map.put(s, o.toString()));
                        }
                    }
                }
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)map);
                properties.store(outputStream, null);
            }
            catch (Throwable e) {
                JaLog.warn((String)"final.properties store error:{}", (Object[])new Object[]{e});
            }
        }
    }

    public static <T> void refresh(Class<T> configBeanClass) {
        JaProperty.getPropertyMap().forEach(jaProperties::put);
        Object targetConfigBean = JaSpringBeanUtil.getBean(configBeanClass);
        ConfigurationPropertiesBindingPostProcessor bindingPostProcessor = (ConfigurationPropertiesBindingPostProcessor)JaSpringBeanUtil.getBean(ConfigurationPropertiesBindingPostProcessor.class);
        assert (bindingPostProcessor != null);
        assert (targetConfigBean != null);
        Object[] beanNamesForType = JaSpringContextUtil.getApplicationContext().getBeanNamesForType(configBeanClass);
        if (JaCollectionUtil.isNotEmpty((Object[])beanNamesForType)) {
            Object beanName = beanNamesForType[0];
            bindingPostProcessor.postProcessBeforeInitialization(targetConfigBean, (String)beanName);
        } else {
            JaLog.warn((String)"{} config refresh error", (Object[])new Object[]{configBeanClass.getName()});
        }
    }

    public static synchronized void loadLocalConfig(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = JaSpringPropertyProcessor.getMutablePropertySources(environment);
        if (null != propertySources) {
            propertySources = environment.getPropertySources();
            ArrayList applicationConfigPropertySourcesList = new ArrayList();
            propertySources.forEach(propertySource -> {
                if (null != propertySource && propertySource.getName().startsWith(LoadPropertySourcePre)) {
                    Object source = propertySource.getSource();
                    if (source instanceof Map) {
                        Map sourceMap = (Map)source;
                        if (JaCollectionUtil.isNotEmpty((Map)sourceMap)) {
                            applicationConfigPropertySourcesList.add(sourceMap);
                        }
                    } else {
                        JaLog.info((String)"unknown propertySource, name:{}", (Object[])new Object[]{propertySource.getName()});
                    }
                }
            });
            if (JaCollectionUtil.isNotEmpty(applicationConfigPropertySourcesList)) {
                for (int i = applicationConfigPropertySourcesList.size() - 1; i >= 0; --i) {
                    ((Map)applicationConfigPropertySourcesList.get(i)).forEach((s, o) -> JaProperty.put((String)s, (Object)o.toString()));
                }
            }
        }
    }

    public static MutablePropertySources getMutablePropertySources(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = null;
        if (environment instanceof AbstractEnvironment) {
            propertySources = environment.getPropertySources();
        } else {
            JaLog.get().warn("not support this environment{}", (Object)environment.getClass().getName());
        }
        return propertySources;
    }
}

