/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.boot.dapper;

import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspect;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import java.util.List;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"ja.dapper.init"}, havingValue="true")
public class JaDapperConfiguration
implements SmartInitializingSingleton {
    @Resource
    private List<JaNodeSpanResolver> resolverList;
    @Resource
    private List<JaDapperAspectPointcut> pointcutList;

    public void afterSingletonsInstantiated() {
        JaNodeSpanResolver.Container.init(this.resolverList);
    }

    @Bean
    public AspectJExpressionPointcutAdvisor dapperAspect() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        String pointcut = JaDapperAspectPointcut.Container.get(this.pointcutList);
        JaLog.info((String)"dapperAspect pointcut : {}", (Object[])new Object[]{pointcut});
        advisor.setExpression(pointcut);
        advisor.setOrder(-10);
        advisor.setAdvice((Advice)new JaDapperAspect());
        return advisor;
    }
}

