package com.jugg.agile.spring.boot.dapper.node;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.aspect.JaDapperAspectPointcut;
import com.jugg.agile.framework.core.dapper.aspect.JaNodeSpanResolver;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.dapper.meta.DapperAnnotation;
import com.jugg.agile.framework.core.dapper.meta.NodeKind;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.bytecode.aop.JaAopUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass({Scheduled.class})
public class JaNodeSpanScheduled implements JaNodeSpanResolver, JaDapperAspectPointcut {

    private static final NodeKind schedulerNodeKind = new NodeKind("scheduler", true)
            .buildDapperAnnotation(DapperAnnotation.InstanceSkip)
            .buildAspectInitialHandler((objects, respSpan, invocation) -> JaMDC.remove())
            .buildAspectFinalHandler((objects, respSpan, invocation) -> JaMDC.put(JaMDC.createTraceId()));

    @Override
    public NodeSpan getNodeSpan(MethodInvocation invocation) {
        if (null != JaAopUtil.getMethodAnnotation(invocation, Scheduled.class)) {
            return get(schedulerNodeKind);
        }
        return null;
    }

    @Override
    public String getExpression() {
        String expression = JaProperty.get("ja.dapper.aspect.pointcut.scheduler");
        if (JaStringUtil.isNotEmpty(expression)) {
            return expression;
        }
        return "@annotation(org.springframework.scheduling.annotation.Scheduled)";
    }
}
