package com.jugg.agile.spring.boot.core;

import com.jugg.agile.framework.core.util.JaSpiUtil;
import com.jugg.agile.framework.core.util.JaStartupHookUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.boot.JaAutoConfiguration;
import com.jugg.agile.spring.boot.core.context.JaContextProcessor;
import com.jugg.agile.spring.boot.util.JaSpringBootUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

import java.util.Set;

/**
 * 注意高低版本spring-boot兼容
 *
 * @author chenjian
 * @since 2024年04月21日 18:59:42
 */
public class JaSpringApplicationRunListener implements SpringApplicationRunListener, Ordered {

    public JaSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
        if (!JaSpringBootUtil.isCloudContainer()) {
            JaSpringBootUtil.setSpringApplication(springApplication);
            JaSpringBootUtil.setArgs(args);
            JaStartupHookUtil.start();
//        JaLogback.addFilter(JaLogbackFilter.class);
        }
    }


    public void starting() {
        if (!JaSpringBootUtil.isCloudContainer()) {
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
//    public void environmentPrepared(ConfigurableBootstrapContext , ConfigurableEnvironment environment) {
        if (!JaSpringBootUtil.isCloudContainer()) {
//            JaSpringPropertyProcessor.initJaProperty(environment);

        }
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context) {
//    public void started(ConfigurableApplicationContext context, Duration timeTaken) {
        if (!JaSpringBootUtil.isCloudContainer()) {
        }
    }

    @Override
    public void running(ConfigurableApplicationContext context) {
        if (!JaSpringBootUtil.isCloudContainer()) {
        }
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        if (!JaSpringBootUtil.isCloudContainer()) {
        }
    }

    @Override
    public int getOrder() {
        return -10;
    }


    public static void environmentPrepared() {
        JaSpiUtil.initCustomBasePackageSet();
        JaSpiUtil.getCustomBasePackageSet().add(JaAutoConfiguration.BasePackage);
        Set<String> rootPackageSet = JaSpringBootUtil.getRootPackageSet();
        if (JaCollectionUtil.isNotEmpty(rootPackageSet)) {
            JaSpiUtil.getCustomBasePackageSet().addAll(rootPackageSet);
        }
        JaContextProcessor.init();
    }
}