package com.jugg.agile.spring.cloud.discovery;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.util.io.net.JaIPUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

import java.util.List;
import java.util.Objects;

public class JaDiscoveryClient {
    /**
     * 获取所有实例
     *
     * @param serviceId 服务名
     */
    public static List<ServiceInstance> getInstances(String serviceId) {
        return Objects.requireNonNull(JaSpringBeanUtil.getBean(DiscoveryClient.class)).getInstances(serviceId);
    }

    /**
     * 获取自身IP的实例
     *
     * @param serviceId 服务名
     */
    public static ServiceInstance getSelfInstance(String serviceId) {
        List<ServiceInstance> instances = getInstances(serviceId);
        String ip = JaIPUtil.getLocalIP();
        if (JaSystemProperty.isWindows()) {
            ip = JaProperty.get("test.localip", "10.176.80.188");
        }
        for (ServiceInstance instance : instances) {
            if (ip.equals(instance.getHost())) {
                return instance;
            }
        }
        return null;
    }
}

