/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.cloud.discovery;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;
import com.jugg.agile.framework.core.util.io.net.JaIPUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class JaDiscoveryClient {
    public static List<ServiceInstance> getInstances(String serviceId) {
        return ((DiscoveryClient)Objects.requireNonNull(JaSpringBeanUtil.getBean(DiscoveryClient.class))).getInstances(serviceId);
    }

    public static ServiceInstance getSelfInstance(String serviceId) {
        List<ServiceInstance> instances = JaDiscoveryClient.getInstances(serviceId);
        String ip = JaIPUtil.getLocalIP();
        if (JaSystemProperty.isWindows()) {
            ip = JaProperty.get((String)"test.localip", (String)"10.176.80.188");
        }
        for (ServiceInstance instance : instances) {
            if (!ip.equals(instance.getHost())) continue;
            return instance;
        }
        return null;
    }
}

