package com.jugg.agile.spring.util;

import com.jugg.agile.framework.core.util.JaStringUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/**
 * get bean factory util
 *
 * @author chenjian
 * @since 2024年01月10日 10:44:04
 */
public class JaSpringBeanFactoryUtil {

    private JaSpringBeanFactoryUtil() {
    }

    public static void registerBeanDefinition(String beanName, Class<?> beanClass) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        BeanDefinition beanDefinition = builder.getBeanDefinition();
        getDefaultListableBeanFactory().registerBeanDefinition(beanName, beanDefinition);

    }

    public static void registerSingleton(Object beanInstance) {
        String beanName = JaStringUtil.lowerFirstCase(beanInstance.getClass().getSimpleName());
        getDefaultListableBeanFactory().registerSingleton(beanName, beanInstance);
    }

    public static void registerSingleton(String beanName, Object beanInstance) {
        getDefaultListableBeanFactory().registerSingleton(beanName, beanInstance);
    }

    public static DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return (DefaultListableBeanFactory) JaSpringContextUtil.getBeanFactory();
    }
}
