package com.jugg.agile.spring.util;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class JaSpringContextUtil implements ApplicationContextAware {

    private static Environment environment;
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;


    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() {
        return beanFactory;
    }

    @Override
    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        JaSpringContextUtil.applicationContext = applicationContext;
        JaSpringContextUtil.environment = applicationContext.getEnvironment();
        JaSpringContextUtil.beanFactory = ((ConfigurableApplicationContext) applicationContext).getBeanFactory();
    }
}
