/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.util;

import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringContextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JaSpringBeanUtil {
    private JaSpringBeanUtil() {
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)JaSpringContextUtil.getApplicationContext().getBean(clazz);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T getBean(String name) {
        try {
            return (T)JaSpringContextUtil.getApplicationContext().getBean(name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> Map<String, T> getBeanMap(Class<T> clazz) {
        try {
            return JaSpringContextUtil.getApplicationContext().getBeansOfType(clazz);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> List<T> getBeanList(Class<T> clazz) {
        Map<String, T> map = JaSpringBeanUtil.getBeanMap(clazz);
        return JaCollectionUtil.isEmpty(map) ? null : new ArrayList<T>(map.values());
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        try {
            return (T)JaSpringContextUtil.getApplicationContext().getBean(name, requiredType);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

