/*
 * Decompiled with CFR 0.152.
 */
package com.jugg.agile.spring.util;

import com.jugg.agile.framework.core.context.JaContext;
import com.jugg.agile.framework.core.util.JaSpiUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.JaClassUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import com.jugg.agile.spring.util.JaSpringClassUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class JaSpringContextUtil
implements ApplicationContextAware {
    private static Environment environment;
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() {
        return beanFactory;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        JaSpringContextUtil.applicationContext = applicationContext;
        environment = applicationContext.getEnvironment();
        beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        Map componentScans = applicationContext.getBeansWithAnnotation(ComponentScan.class);
        for (Object bean : componentScans.values()) {
            Object[] strings;
            ComponentScan annotation = JaSpringAopUtil.getSingletonTarget(bean).getClass().getAnnotation(ComponentScan.class);
            ComponentScan annotation1 = (ComponentScan)AnnotatedElementUtils.findMergedAnnotation(JaSpringAopUtil.getSingletonTarget(bean).getClass(), ComponentScan.class);
            if (null == annotation || !JaCollectionUtil.isNotEmpty((Object[])(strings = annotation.basePackages()))) continue;
            JaSpiUtil.getCustomBasePackageSet().addAll(Arrays.asList(strings));
        }
        HashSet readableResource = new HashSet();
        JaSpiUtil.getCustomBasePackageSet().forEach(s -> readableResource.addAll(JaSpringClassUtil.getReadableResource(s)));
        String name = JaContext.class.getName();
        readableResource.forEach(metadataReader -> {
            System.out.println(metadataReader.getClassMetadata().getSuperClassName());
            if (name.equals(metadataReader.getClassMetadata().getSuperClassName())) {
                JaClassUtil.load((String)JaSpringClassUtil.getClassPath(metadataReader));
            }
        });
    }
}

