package com.jugg.agile.spring.util;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import lombok.SneakyThrows;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

import java.util.ArrayList;
import java.util.List;

public class JaSpringClassUtil {

    @SneakyThrows
    public static List<MetadataReader> getReadableResource(String packageName) {
        packageName = ClassUtils.convertClassNameToResourcePath(packageName);
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = pathMatchingResourcePatternResolver.getResources("classpath*:" + packageName + "/**/*.class");
        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory();
        List<MetadataReader> metadataReaderList = new ArrayList<>();
        for (Resource resource : resources) {
            if (resource.isReadable()) {
                metadataReaderList.add(readerFactory.getMetadataReader(resource));
            } else {
                JaLog.warn("{} scan class is not readable {}", packageName, resource.getFilename());
            }
        }
        return metadataReaderList;
    }
}
