/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.ClientSidePreparedStatement;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.util.ParsedCallParameters;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallableParameterMetaData
implements ParameterMetaData {
    protected static final Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)+(\\`[\\w\\d\\S]+\\`)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(?=,?|\\))", 2);
    protected static final Pattern PARAMETER_PATTERN_MYSQL_MODE_NOT_INFORMATION_SCHEMA = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?(\\`[\\w\\d\\S]+\\`)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(?=,?|\\))", 2);
    protected static final Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(CHARSET\\s+)?(\\w+|\\w+\\s+|\\w+\\s+\\w+|\\w+\\s+\\w+\\s+\\w+)?\\s*", 2);
    protected final OceanBaseConnection con;
    protected boolean isOracleMode;
    protected final String name;
    protected List<CallParameter> placeholderParams;
    protected List<CallParameter> allParams;
    protected int[] placeholderToParameterIndexMap;
    protected String obOraclePackageName;
    protected String obOracleSchema;
    protected String database;
    protected boolean valid;
    protected boolean isFunction;
    protected String query;
    protected SQLException outputParamSetParamValueException;
    protected int parameterCountOfStmt;

    public String getProName() {
        return this.name;
    }

    public String getDatabase() {
        return this.database;
    }

    public CallableParameterMetaData(OceanBaseConnection con, String database, String name, boolean isFunction) {
        this.con = con;
        this.isOracleMode = con.getProtocol().isOracleMode();
        if (database != null) {
            String tmp = database.replace("`", "");
            if (this.isOracleMode) {
                if (tmp.equals(this.con.getProtocol().getDatabase())) {
                    this.database = tmp;
                    this.obOracleSchema = tmp;
                } else if (tmp.contains(".")) {
                    String[] databaseAndPackage = tmp.split("\\.");
                    if (databaseAndPackage.length == 2) {
                        this.obOraclePackageName = databaseAndPackage[1].startsWith("\"") && databaseAndPackage[1].endsWith("\"") ? databaseAndPackage[1].replace("\"", "") : databaseAndPackage[1].toUpperCase(Locale.ROOT);
                        this.obOracleSchema = databaseAndPackage[0].startsWith("\"") && databaseAndPackage[0].endsWith("\"") ? databaseAndPackage[0].replace("\"", "") : databaseAndPackage[0].toUpperCase(Locale.ROOT);
                        this.database = databaseAndPackage[0];
                    }
                } else {
                    if (tmp.startsWith("\"") && tmp.startsWith("\"")) {
                        if (tmp.replace("\"", "").equals(this.con.getProtocol().getDatabase())) {
                            this.obOracleSchema = tmp.replace("\"", "");
                            this.obOraclePackageName = null;
                        } else {
                            this.obOracleSchema = null;
                            this.obOraclePackageName = tmp.replace("\"", "");
                        }
                    } else if (tmp.equals(this.con.getProtocol().getDatabase()) || tmp.toUpperCase(Locale.ROOT).equals(this.con.getProtocol().getDatabase())) {
                        this.obOraclePackageName = null;
                        this.obOracleSchema = tmp.toUpperCase(Locale.ROOT);
                    } else {
                        this.obOraclePackageName = tmp.toUpperCase(Locale.ROOT);
                        this.obOracleSchema = null;
                    }
                    this.database = this.con.getProtocol().getDatabase();
                }
            } else {
                this.database = database;
            }
        } else {
            this.database = null;
        }
        this.name = name.startsWith("\"") && name.endsWith("\"") ? name.replace("`", "").replace("\"", "") : (this.isOracleMode ? name.replace("`", "").toUpperCase(Locale.ROOT) : name);
        this.isFunction = isFunction;
    }

    public void readMetadataFromDbIfRequired() throws SQLException {
        if (this.valid) {
            return;
        }
        this.readMetadata();
        this.valid = true;
    }

    public void generateMetadataFromPrepareResultSet(ServerPrepareResult serverPrepareResult) throws SQLException {
        if (this.valid) {
            return;
        }
        this.allParams = new ArrayList<CallParameter>();
        ColumnDefinition[] parameters = serverPrepareResult.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            CallParameter callParameter = new CallParameter();
            this.allParams.add(callParameter);
        }
        this.valid = false;
    }

    public void readMetadataFromDbIfRequired(String query, String arguments, Boolean isObFunction) throws SQLException {
        if (this.valid) {
            return;
        }
        this.query = query;
        this.readMetadata();
        this.resetParams(arguments, isObFunction);
        this.valid = true;
    }

    void resetParams(String arguments, boolean isObFunction) throws SQLException {
        List<Object> paramList = new ArrayList();
        if (arguments != null) {
            arguments = Utils.trimSQLString(arguments, false, true, false);
            paramList = Utils.argumentsSplit(arguments, ",", "'\"", "'\"");
        }
        boolean haveSpecialParameters = false;
        Pattern specialParametersPattern = Pattern.compile("\\w+\\s*=>\\s*\\?");
        for (int i = 0; i < paramList.size(); ++i) {
            String parsedCallParameterName = ((ParsedCallParameters)paramList.get(i)).getName();
            if (!specialParametersPattern.matcher(parsedCallParameterName).find()) continue;
            haveSpecialParameters = true;
            paramList.set(i, new ParsedCallParameters(true, parsedCallParameterName.split("=")[0].trim()));
        }
        if (isObFunction) {
            paramList.add(0, new ParsedCallParameters(true, "?"));
        }
        this.placeholderToParameterIndexMap = new int[paramList.size()];
        int placeholderCount = 0;
        for (int i = 0; i < paramList.size(); ++i) {
            if (((ParsedCallParameters)paramList.get(i)).isParam()) {
                this.placeholderToParameterIndexMap[placeholderCount++] = i;
                continue;
            }
            this.placeholderToParameterIndexMap[i] = -1;
        }
        ArrayList<CallParameter> currentParams = new ArrayList<CallParameter>(placeholderCount);
        for (int index = 0; index < this.allParams.size(); ++index) {
            CallParameter parameter = this.allParams.get(index);
            boolean found = false;
            int len = this.placeholderToParameterIndexMap.length;
            for (int placeholderIndex = 0; placeholderIndex < len; ++placeholderIndex) {
                if (this.placeholderToParameterIndexMap[placeholderIndex] == index) {
                    found = true;
                    currentParams.add(parameter);
                    break;
                }
                if (this.placeholderToParameterIndexMap[placeholderIndex] > index || this.placeholderToParameterIndexMap[placeholderIndex] == -1) break;
            }
            if (found || !parameter.isOutput() || this.outputParamSetParamValueException != null) continue;
            this.outputParamSetParamValueException = new SQLException("Parameter " + parameter.getName() + " is not registered as an output parameter.");
        }
        for (int i = this.allParams.size(); i < paramList.size(); ++i) {
            currentParams.add(new CallParameter());
        }
        this.placeholderParams = currentParams;
        if (haveSpecialParameters) {
            this.placeholderParams = new ArrayList<CallParameter>(currentParams.size());
            for (int paramListIndex = 0; paramListIndex < paramList.size(); ++paramListIndex) {
                ParsedCallParameters parsedCallParameter = (ParsedCallParameters)paramList.get(paramListIndex);
                String parsedCallParameterName = parsedCallParameter.getName();
                boolean found = false;
                for (int currentParamIndex = 0; currentParamIndex < currentParams.size(); ++currentParamIndex) {
                    CallParameter parameter = (CallParameter)currentParams.get(currentParamIndex);
                    String parameterName = parameter.getName();
                    if (parameterName.startsWith("`") && parameterName.endsWith("`") && !parsedCallParameterName.startsWith("`")) {
                        parsedCallParameterName = "`" + parsedCallParameterName + "`";
                    }
                    if (!parsedCallParameterName.equalsIgnoreCase(parameterName)) continue;
                    this.placeholderParams.add(parameter);
                    found = true;
                    break;
                }
                if (found || !parsedCallParameter.isParam()) continue;
                throw new SQLException("param matching error");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String[] queryMetaInfos(boolean isFunction) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CallParameter parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = new CallParameter();
        callParameter.setOutput(true);
        callParameter.setSigned(matcher.group(1) == null);
        String typeName = matcher.group(2).trim();
        callParameter.setTypeName(typeName);
        int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
        callParameter.setSqlType(sqlType);
        callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
        String columnSize = matcher.group(3);
        if (columnSize != null) {
            if ((columnSize = columnSize.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                columnSize = columnSize.substring(0, columnSize.indexOf(","));
            }
            callParameter.setPrecision(Integer.parseInt(columnSize));
        }
        return callParameter;
    }

    private void parseParamList(boolean isFunction, String paramList) throws SQLException {
        int returnIndex;
        this.allParams = new ArrayList<CallParameter>();
        int index = 0;
        if (isFunction && (returnIndex = paramList.indexOf("RETURNS")) != -1) {
            int bodyStartInedx = paramList.toUpperCase(Locale.ROOT).indexOf("BEGIN");
            String returnString = paramList.substring(returnIndex + "RETURNS".length(), bodyStartInedx);
            paramList = paramList.substring(0, returnIndex - 1);
            CallParameter parameterRetrurn = this.parseFunctionReturnParam(returnString);
            parameterRetrurn.setIndex(index++);
            this.allParams.add(parameterRetrurn);
        }
        Matcher matcher2 = isFunction && !this.isOracleMode && !this.con.getProtocol().haveInformationSchemaParameters() ? PARAMETER_PATTERN_MYSQL_MODE_NOT_INFORMATION_SCHEMA.matcher(paramList) : PARAMETER_PATTERN.matcher(paramList);
        while (matcher2.find()) {
            CallParameter callParameter = new CallParameter();
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.setInput(true);
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.setOutput(true);
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.setInput(true);
                callParameter.setOutput(true);
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.getName());
            }
            callParameter.setName(matcher2.group(2).trim());
            callParameter.setSigned(matcher2.group(3) == null);
            String typeName = matcher2.group(4).trim().toUpperCase(Locale.ROOT);
            callParameter.setTypeName(typeName);
            int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
            callParameter.setSqlType(sqlType);
            callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
            String columnSize = matcher2.group(5);
            if (columnSize != null) {
                if ((columnSize = columnSize.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    int delimiter = columnSize.indexOf(",");
                    if (delimiter != -1) {
                        callParameter.setScale(Integer.parseInt(columnSize.substring(delimiter + 1)));
                    }
                    columnSize = columnSize.substring(0, delimiter);
                }
                callParameter.setPrecision(Integer.parseInt(columnSize));
            }
            this.allParams.add(callParameter);
            callParameter.setIndex(index++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMetadata() throws SQLException {
        String procedureDDl;
        if (this.name == null || this.name.equals("")) {
            return;
        }
        if (!this.isOracleMode && this.con.getProtocol().haveInformationSchemaParameters()) {
            this.readMetadataUsingInformationSchema();
            return;
        }
        Statement stmt = this.con.getMetadataSafeStatement();
        try (ResultSet resultSet = null;){
            if (this.isFunction) {
                resultSet = this.database != null ? stmt.executeQuery("SHOW CREATE FUNCTION " + this.database + "." + this.name) : stmt.executeQuery("SHOW CREATE FUNCTION " + this.name);
                resultSet.next();
                procedureDDl = resultSet.getString("Create Function");
            } else {
                resultSet = this.database != null ? stmt.executeQuery("SHOW CREATE PROCEDURE " + this.database + "." + this.name) : stmt.executeQuery("SHOW CREATE PROCEDURE " + this.name);
                resultSet.next();
                procedureDDl = resultSet.getString("Create Procedure");
            }
        }
        String paramList = procedureDDl.substring(procedureDDl.indexOf("(") - 1);
        this.parseParamList(this.isFunction, paramList);
    }

    private void readMetadataUsingInformationSchema() throws SQLException {
        ClientSidePreparedStatement cps;
        if (this.database != null && !this.database.equals("")) {
            cps = this.con.clientPrepareStatement("SELECT * from information_schema.PARAMETERS WHERE ROUTINE_TYPE = ? AND SPECIFIC_NAME = ? AND SPECIFIC_SCHEMA = ? ORDER BY ORDINAL_POSITION", 2);
            cps.setString(3, this.database.replace("`", "").toUpperCase(Locale.ROOT));
        } else {
            cps = this.con.clientPrepareStatement("SELECT * from information_schema.PARAMETERS WHERE ROUTINE_TYPE = ? AND SPECIFIC_NAME = ? ORDER BY ORDINAL_POSITION", 2);
        }
        cps.setString(1, this.isFunction ? "FUNCTION" : "PROCEDURE");
        cps.setString(2, this.name.replace("`", "").toUpperCase(Locale.ROOT));
        ResultSet rs = cps.executeQuery();
        this.allParams = new ArrayList<CallParameter>();
        if (rs.next()) {
            String specificSchema = rs.getString("SPECIFIC_SCHEMA");
            int count = 0;
            do {
                CallParameter callParameter = new CallParameter();
                callParameter.setName(rs.getString("PARAMETER_NAME"));
                callParameter.setSigned(!rs.getString("DTD_IDENTIFIER").contains(" unsigned"));
                String direction = rs.getString("PARAMETER_MODE");
                if (direction != null) {
                    if (direction.equalsIgnoreCase("IN")) {
                        callParameter.setInput(true);
                    } else if (direction.equalsIgnoreCase("OUT")) {
                        callParameter.setOutput(true);
                    } else if (direction.equalsIgnoreCase("INOUT")) {
                        callParameter.setInput(true);
                        callParameter.setOutput(true);
                    }
                }
                String typeName = rs.getString("DATA_TYPE").toUpperCase(Locale.ROOT);
                callParameter.setTypeName(typeName);
                int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
                callParameter.setSqlType(sqlType);
                callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
                int characterMaxLength = rs.getInt("CHARACTER_MAXIMUM_LENGTH");
                int numericPrecision = rs.getInt("NUMERIC_PRECISION");
                callParameter.setPrecision(numericPrecision > 0 ? numericPrecision : characterMaxLength);
                callParameter.setScale(rs.getInt("NUMERIC_SCALE"));
                callParameter.setIndex(count++);
                this.allParams.add(callParameter);
            } while (rs.next() && rs.getString("SPECIFIC_SCHEMA").equals(specificSchema));
        }
        cps.close();
        rs.close();
    }

    @Override
    public int getParameterCount() {
        return this.placeholderParams != null ? this.placeholderParams.size() : this.parameterCountOfStmt;
    }

    public CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index > this.placeholderParams.size()) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDbIfRequired();
        return this.allParams.get(this.placeholderParams.get(index - 1).getIndex());
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam(param).getCanBeNull();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam(param).getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam(param).getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam(param).getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter callParameter = this.getParam(param);
        if (callParameter.isInput() && callParameter.isOutput()) {
            return 2;
        }
        if (callParameter.isInput()) {
            return 1;
        }
        if (callParameter.isOutput()) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam(param).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    public boolean hasEmptyPlaceholderParams() {
        return this.placeholderParams == null || this.placeholderParams.isEmpty();
    }

    public CallParameter getPlaceholderParam(int index) {
        if (this.hasEmptyPlaceholderParams()) {
            return null;
        }
        return this.placeholderParams.get(index);
    }
}

