/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.Lob;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class LobOutputStream
extends OutputStream {
    private final Lob lob;
    private int pos;

    public LobOutputStream(Lob lob, int pos) {
        this.lob = lob;
        this.pos = pos;
    }

    @Override
    public void write(int bit) throws IOException {
        if (this.pos >= this.lob.length) {
            byte[] tmp = new byte[2 * this.lob.length + 1];
            System.arraycopy(this.lob.data, this.lob.offset, tmp, 0, this.lob.length);
            this.lob.data = tmp;
            this.pos -= this.lob.offset;
            this.lob.offset = 0;
            ++this.lob.length;
        }
        this.lob.data[this.pos] = (byte)bit;
        ++this.pos;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0) {
            throw new IOException("Invalid offset " + off);
        }
        int realLen = Math.min(buf.length - off, len);
        if (this.pos + realLen >= this.lob.length) {
            int newLen = Math.min(this.lob.length, this.pos) + realLen;
            if (this.lob.isOracleMode) {
                newLen = this.pos + realLen;
            }
            byte[] tmp = new byte[newLen];
            if (this.lob instanceof Clob) {
                Arrays.fill(tmp, (byte)32);
            }
            System.arraycopy(this.lob.data, this.lob.offset, tmp, 0, this.lob.length);
            this.lob.data = tmp;
            this.pos -= this.lob.offset;
            this.lob.offset = 0;
            this.lob.length = this.pos + realLen;
        }
        System.arraycopy(buf, off, this.lob.data, this.pos, realLen);
        this.lob.charData = new String(this.lob.data, 0, this.lob.length, Charset.forName(this.lob.encoding == null ? "UTF-8" : this.lob.encoding));
        this.pos += realLen;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        if (this.lob.isOracleMode && buf.length == 0) {
            return;
        }
        this.write(buf, 0, buf.length);
    }
}

