/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.advisory;

import com.primeton.pmq.PMQMessageConsumer;
import com.primeton.pmq.Service;
import com.primeton.pmq.advisory.AdvisorySupport;
import com.primeton.pmq.advisory.ConsumerEvent;
import com.primeton.pmq.advisory.ConsumerListener;
import com.primeton.pmq.advisory.ConsumerStartedEvent;
import com.primeton.pmq.advisory.ConsumerStoppedEvent;
import com.primeton.pmq.command.ConsumerId;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DataStructure;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQMessage;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.RemoveInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerEventSource
implements Service,
MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerEventSource.class);
    private final Connection connection;
    private final PMQDestination destination;
    private ConsumerListener listener;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicInteger consumerCount = new AtomicInteger();
    private Session session;
    private PMQMessageConsumer consumer;

    public ConsumerEventSource(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = PMQDestination.transform(destination);
    }

    public void setConsumerListener(ConsumerListener listener) {
        this.listener = listener;
    }

    public String getConsumerId() {
        return this.consumer != null ? this.consumer.getConsumerId().toString() : "NOT_SET";
    }

    @Override
    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.session = this.connection.createSession(false, 1);
            PMQTopic advisoryTopic = AdvisorySupport.getConsumerAdvisoryTopic(this.destination);
            this.consumer = (PMQMessageConsumer)this.session.createConsumer((Destination)advisoryTopic);
            this.consumer.setMessageListener(this);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void onMessage(Message message) {
        if (message instanceof PMQMessage) {
            PMQMessage activeMessage = (PMQMessage)message;
            DataStructure command = activeMessage.getDataStructure();
            int count = 0;
            if (command instanceof ConsumerInfo) {
                count = this.consumerCount.incrementAndGet();
                count = this.extractConsumerCountFromMessage(message, count);
                this.fireConsumerEvent(new ConsumerStartedEvent(this, this.destination, (ConsumerInfo)command, count));
            } else if (command instanceof RemoveInfo) {
                RemoveInfo removeInfo = (RemoveInfo)command;
                if (removeInfo.isConsumerRemove()) {
                    count = this.consumerCount.decrementAndGet();
                    count = this.extractConsumerCountFromMessage(message, count);
                    this.fireConsumerEvent(new ConsumerStoppedEvent(this, this.destination, (ConsumerId)removeInfo.getObjectId(), count));
                }
            } else {
                LOG.warn("Unknown command: " + command);
            }
        } else {
            LOG.warn("Unknown message type: " + message + ". Message ignored");
        }
    }

    protected int extractConsumerCountFromMessage(Message message, int count) {
        try {
            Object value = message.getObjectProperty("consumerCount");
            if (value instanceof Number) {
                Number n = (Number)value;
                return n.intValue();
            }
            LOG.warn("No consumerCount header available on the message: " + message);
        }
        catch (Exception e) {
            LOG.warn("Failed to extract consumerCount from message: " + message + ".Reason: " + e, (Throwable)e);
        }
        return count;
    }

    protected void fireConsumerEvent(ConsumerEvent event) {
        if (this.listener != null) {
            this.listener.onConsumerEvent(event);
        }
    }
}

