/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.blob;

import com.primeton.pmq.blob.BlobTransferPolicy;
import com.primeton.pmq.blob.BlobUploadStrategy;
import com.primeton.pmq.command.PMQBlobMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jms.JMSException;

public class BlobUploader {
    private final BlobTransferPolicy blobTransferPolicy;
    private File file;
    private InputStream in;

    public BlobUploader(BlobTransferPolicy blobTransferPolicy, InputStream in) {
        this.blobTransferPolicy = blobTransferPolicy.copy();
        this.in = in;
    }

    public BlobUploader(BlobTransferPolicy blobTransferPolicy, File file) {
        this.blobTransferPolicy = blobTransferPolicy.copy();
        this.file = file;
    }

    public URL upload(PMQBlobMessage message) throws JMSException, IOException {
        if (this.file != null) {
            return this.getStrategy().uploadFile(message, this.file);
        }
        return this.getStrategy().uploadStream(message, this.in);
    }

    public BlobTransferPolicy getBlobTransferPolicy() {
        return this.blobTransferPolicy;
    }

    public BlobUploadStrategy getStrategy() {
        return this.getBlobTransferPolicy().getUploadStrategy();
    }
}

