/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.blob;

import com.primeton.pmq.blob.BlobDownloadStrategy;
import com.primeton.pmq.blob.BlobTransferPolicy;
import com.primeton.pmq.blob.FTPStrategy;
import com.primeton.pmq.command.PMQBlobMessage;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.jms.JMSException;
import org.apache.commons.net.ftp.FTPClient;

public class FTPBlobDownloadStrategy
extends FTPStrategy
implements BlobDownloadStrategy {
    public FTPBlobDownloadStrategy(BlobTransferPolicy transferPolicy) throws MalformedURLException {
        super(transferPolicy);
    }

    @Override
    public InputStream getInputStream(PMQBlobMessage message) throws IOException, JMSException {
        this.url = message.getURL();
        final FTPClient ftp = this.createFTP();
        String path = this.url.getPath();
        String workingDir = path.substring(0, path.lastIndexOf("/"));
        String file = path.substring(path.lastIndexOf("/") + 1);
        ftp.changeWorkingDirectory(workingDir);
        ftp.setFileType(2);
        FilterInputStream input = new FilterInputStream(ftp.retrieveFileStream(file)){

            @Override
            public void close() throws IOException {
                this.in.close();
                ftp.quit();
                ftp.disconnect();
            }
        };
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(PMQBlobMessage message) throws IOException, JMSException {
        this.url = message.getURL();
        FTPClient ftp = this.createFTP();
        String path = this.url.getPath();
        try {
            if (!ftp.deleteFile(path)) {
                throw new JMSException("Delete file failed: " + ftp.getReplyString());
            }
        }
        finally {
            ftp.quit();
            ftp.disconnect();
        }
    }
}

