/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.inteceptor;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.inteceptor.MessageInterceptor;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.filter.DestinationMap;
import com.primeton.pmq.state.ProducerState;
import java.util.Set;

class MessageInterceptorFilter
extends BrokerFilter {
    private DestinationMap interceptorMap = new DestinationMap();

    MessageInterceptorFilter(Broker next) {
        super(next);
    }

    MessageInterceptor addMessageInterceptor(String destinationName, MessageInterceptor messageInterceptor) {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, (byte)1);
        this.interceptorMap.put(pmqDestination, messageInterceptor);
        return messageInterceptor;
    }

    void removeMessageInterceptor(String destinationName, MessageInterceptor interceptor) {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, (byte)1);
        this.interceptorMap.remove(pmqDestination, interceptor);
    }

    MessageInterceptor addMessageInterceptorForQueue(String destinationName, MessageInterceptor messageInterceptor) {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, (byte)1);
        this.interceptorMap.put(pmqDestination, messageInterceptor);
        return messageInterceptor;
    }

    void removeMessageInterceptorForQueue(String destinationName, MessageInterceptor interceptor) {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, (byte)1);
        this.interceptorMap.remove(pmqDestination, interceptor);
    }

    MessageInterceptor addMessageInterceptorForTopic(String destinationName, MessageInterceptor messageInterceptor) {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, (byte)2);
        this.interceptorMap.put(pmqDestination, messageInterceptor);
        return messageInterceptor;
    }

    void removeMessageInterceptorForTopic(String destinationName, MessageInterceptor interceptor) {
        PMQDestination pmqDestination = PMQDestination.createDestination(destinationName, (byte)2);
        this.interceptorMap.remove(pmqDestination, interceptor);
    }

    MessageInterceptor addMessageInterceptor(PMQDestination pmqDestination, MessageInterceptor messageInterceptor) {
        this.interceptorMap.put(pmqDestination, messageInterceptor);
        return messageInterceptor;
    }

    void removeMessageInterceptor(PMQDestination pmqDestination, MessageInterceptor interceptor) {
        this.interceptorMap.remove(pmqDestination, interceptor);
    }

    void injectMessage(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        ProducerBrokerExchange pe = producerExchange;
        if (pe == null) {
            pe = new ProducerBrokerExchange();
            ConnectionContext cc = new ConnectionContext();
            cc.setBroker(this.getRoot());
            pe.setConnectionContext(cc);
            pe.setMutable(true);
            pe.setProducerState(new ProducerState(new ProducerInfo()));
        }
        super.send(pe, messageSend);
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        PMQDestination pmqDestination = messageSend.getDestination();
        if (!this.interceptorMap.isEmpty() && pmqDestination != null) {
            Set set = this.interceptorMap.get(pmqDestination);
            if (set != null && !set.isEmpty()) {
                for (MessageInterceptor mi : set) {
                    mi.intercept(producerExchange, messageSend);
                }
            } else {
                super.send(producerExchange, messageSend);
            }
        } else {
            super.send(producerExchange, messageSend);
        }
    }
}

