/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.jmx;

import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.jmx.ManagedRegionBroker;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFactory;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.TempQueueRegion;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.thread.TaskRunnerFactory;
import com.primeton.pmq.usage.SystemUsage;
import javax.jms.JMSException;
import javax.management.ObjectName;

public class ManagedTempQueueRegion
extends TempQueueRegion {
    private final ManagedRegionBroker regionBroker;

    public ManagedTempQueueRegion(ManagedRegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
        this.regionBroker = broker;
    }

    @Override
    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        Subscription sub = super.createSubscription(context, info);
        ObjectName name = this.regionBroker.registerSubscription(context, sub);
        sub.setObjectName(name);
        return sub;
    }

    @Override
    protected void destroySubscription(Subscription sub) {
        this.regionBroker.unregisterSubscription(sub);
        super.destroySubscription(sub);
    }

    @Override
    protected Destination createDestination(ConnectionContext context, PMQDestination destination) throws Exception {
        Destination rc = super.createDestination(context, destination);
        this.regionBroker.register(destination, rc);
        return rc;
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        super.removeDestination(context, destination, timeout);
        this.regionBroker.unregister(destination);
    }
}

