/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.jmx;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.TransportConnection;
import com.primeton.pmq.broker.TransportConnector;
import com.primeton.pmq.broker.jmx.AnnotatedMBean;
import com.primeton.pmq.broker.jmx.BrokerMBeanSupport;
import com.primeton.pmq.broker.jmx.ConnectionView;
import com.primeton.pmq.broker.jmx.ConnectionViewMBean;
import com.primeton.pmq.broker.jmx.ManagementContext;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.thread.TaskRunnerFactory;
import com.primeton.pmq.transport.Transport;
import com.primeton.pmq.util.IOExceptionSupport;
import java.io.IOException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedTransportConnection
extends TransportConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedTransportConnection.class);
    private final ManagementContext managementContext;
    private final ObjectName connectorName;
    private final ConnectionViewMBean mbean;
    private ObjectName byClientIdName;
    private ObjectName byAddressName;
    private final boolean populateUserName;

    public ManagedTransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory factory, TaskRunnerFactory stopFactory, ManagementContext context, ObjectName connectorName) throws IOException {
        super(connector, transport, broker, factory, stopFactory);
        this.managementContext = context;
        this.connectorName = connectorName;
        this.mbean = new ConnectionView(this, this.managementContext);
        this.populateUserName = broker.getBrokerService().isPopulateUserNameInMBeans();
        if (this.managementContext.isAllowRemoteAddressInMBeanNames()) {
            this.byAddressName = this.createObjectName("remoteAddress", transport.getRemoteAddress());
            this.registerMBean(this.byAddressName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAsync() {
        super.stopAsync();
        ManagedTransportConnection managedTransportConnection = this;
        synchronized (managedTransportConnection) {
            this.unregisterMBean(this.byClientIdName);
            this.unregisterMBean(this.byAddressName);
            this.byClientIdName = null;
            this.byAddressName = null;
        }
    }

    @Override
    public Response processAddConnection(ConnectionInfo info) throws Exception {
        Response answer = super.processAddConnection(info);
        String clientId = info.getClientId();
        if (this.populateUserName) {
            ((ConnectionView)this.mbean).setUserName(info.getUserName());
        }
        if (clientId != null && this.byClientIdName == null) {
            this.byClientIdName = this.createObjectName("clientId", clientId);
            this.registerMBean(this.byClientIdName);
        }
        return answer;
    }

    protected void registerMBean(ObjectName name) {
        if (name != null) {
            try {
                AnnotatedMBean.registerMBean(this.managementContext, this.mbean, name);
            }
            catch (Throwable e) {
                LOG.warn("Failed to register MBean {}", (Object)name);
                LOG.debug("Failure reason: ", e);
            }
        }
    }

    protected void unregisterMBean(ObjectName name) {
        if (name != null) {
            try {
                this.managementContext.unregisterMBean(name);
            }
            catch (Throwable e) {
                LOG.warn("Failed to unregister MBean {}", (Object)name);
                LOG.debug("Failure reason: ", e);
            }
        }
    }

    protected ObjectName createObjectName(String type, String value) throws IOException {
        try {
            return BrokerMBeanSupport.createConnectionViewByType(this.connectorName, type, value);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

