/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.jmx;

import com.primeton.pmq.broker.jmx.ManagedRegionBroker;
import com.primeton.pmq.broker.jmx.RecoveredXATransactionViewMBean;
import com.primeton.pmq.transaction.Synchronization;
import com.primeton.pmq.transaction.XATransaction;

public class RecoveredXATransactionView
implements RecoveredXATransactionViewMBean {
    private final XATransaction transaction;

    public RecoveredXATransactionView(final ManagedRegionBroker managedRegionBroker, final XATransaction transaction) {
        this.transaction = transaction;
        transaction.addSynchronization(new Synchronization(){

            @Override
            public void afterCommit() throws Exception {
                managedRegionBroker.unregister(transaction);
            }

            @Override
            public void afterRollback() throws Exception {
                managedRegionBroker.unregister(transaction);
            }
        });
    }

    @Override
    public int getFormatId() {
        return this.transaction.getXid().getFormatId();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.transaction.getXid().getBranchQualifier();
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.transaction.getXid().getGlobalTransactionId();
    }

    @Override
    public void heuristicCommit() throws Exception {
        this.transaction.commit(false);
    }

    @Override
    public void heuristicRollback() throws Exception {
        this.transaction.rollback();
    }
}

