/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.AbstractRegion;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFactory;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.TempQueueRegion;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.thread.TaskRunnerFactory;
import com.primeton.pmq.usage.SystemUsage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTempRegion
extends AbstractRegion {
    private static final Logger LOG = LoggerFactory.getLogger(TempQueueRegion.class);
    private Map<CachedDestination, Destination> cachedDestinations = new HashMap<CachedDestination, Destination>();
    private final boolean doCacheTempDestinations;
    private final int purgeTime;
    private Timer purgeTimer;
    private TimerTask purgeTask;

    public AbstractTempRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
        this.doCacheTempDestinations = broker.getBrokerService().isCacheTempDestinations();
        this.purgeTime = broker.getBrokerService().getTimeBeforePurgeTempDestinations();
        if (this.doCacheTempDestinations) {
            this.purgeTimer = new Timer("PMQ Temp destination purge timer", true);
            this.purgeTask = new TimerTask(){

                @Override
                public void run() {
                    AbstractTempRegion.this.doPurge();
                }
            };
            this.purgeTimer.schedule(this.purgeTask, this.purgeTime, (long)this.purgeTime);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.purgeTimer != null) {
            this.purgeTimer.cancel();
        }
    }

    @Override
    protected synchronized Destination createDestination(ConnectionContext context, PMQDestination destination) throws Exception {
        Destination result = this.cachedDestinations.remove(new CachedDestination(destination));
        if (result == null) {
            result = this.destinationFactory.createDestination(context, destination, this.destinationStatistics);
        }
        return result;
    }

    @Override
    protected final synchronized void dispose(ConnectionContext context, Destination dest) throws Exception {
        if (this.doCacheTempDestinations) {
            this.cachedDestinations.put(new CachedDestination(dest.getPMQDestination()), dest);
        } else {
            try {
                dest.dispose(context);
                dest.stop();
            }
            catch (Exception e) {
                LOG.warn("Failed to dispose of {}", (Object)dest, (Object)e);
            }
        }
    }

    private void doDispose(Destination dest) {
        ConnectionContext context = new ConnectionContext();
        try {
            dest.dispose(context);
            dest.stop();
        }
        catch (Exception e) {
            LOG.warn("Failed to dispose of {}", (Object)dest, (Object)e);
        }
    }

    private synchronized void doPurge() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedDestinations.size() > 0) {
            HashSet<CachedDestination> tmp = new HashSet<CachedDestination>(this.cachedDestinations.keySet());
            for (CachedDestination key : tmp) {
                Destination dest;
                if (key.timeStamp + (long)this.purgeTime >= currentTime || (dest = this.cachedDestinations.remove(key)) == null) continue;
                this.doDispose(dest);
            }
        }
    }

    static class CachedDestination {
        long timeStamp;
        PMQDestination destination;

        CachedDestination(PMQDestination destination) {
            this.destination = destination;
            this.timeStamp = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.destination.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CachedDestination) {
                CachedDestination other = (CachedDestination)o;
                return other.destination.equals(this.destination);
            }
            return false;
        }
    }
}

