/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.advisory.AdvisorySupport;
import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFactory;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.Queue;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.TempQueue;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.policy.PolicyEntry;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTempDestination;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.command.SubscriptionInfo;
import com.primeton.pmq.store.MessageStore;
import com.primeton.pmq.store.PersistenceAdapter;
import com.primeton.pmq.store.TopicMessageStore;
import com.primeton.pmq.thread.TaskRunnerFactory;
import java.io.IOException;
import java.util.Set;

public class DestinationFactoryImpl
extends DestinationFactory {
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final PersistenceAdapter persistenceAdapter;
    protected RegionBroker broker;
    private final BrokerService brokerService;

    public DestinationFactoryImpl(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        this.brokerService = brokerService;
        this.taskRunnerFactory = taskRunnerFactory;
        if (persistenceAdapter == null) {
            throw new IllegalArgumentException("null persistenceAdapter");
        }
        this.persistenceAdapter = persistenceAdapter;
    }

    @Override
    public void setRegionBroker(RegionBroker broker) {
        if (broker == null) {
            throw new IllegalArgumentException("null broker");
        }
        this.broker = broker;
    }

    @Override
    public Set<PMQDestination> getDestinations() {
        return this.persistenceAdapter.getDestinations();
    }

    @Override
    public Destination createDestination(ConnectionContext context, PMQDestination destination, DestinationStatistics destinationStatistics) throws Exception {
        if (destination.isQueue()) {
            if (destination.isTemporary()) {
                PMQTempDestination tempDest = (PMQTempDestination)destination;
                TempQueue queue2 = new TempQueue(this.brokerService, destination, null, destinationStatistics, this.taskRunnerFactory);
                this.configureQueue(queue2, destination);
                ((Queue)queue2).initialize();
                return queue2;
            }
            MessageStore store2 = this.persistenceAdapter.createQueueMessageStore((PMQQueue)destination);
            Queue queue3 = new Queue(this.brokerService, destination, store2, destinationStatistics, this.taskRunnerFactory);
            this.configureQueue(queue3, destination);
            queue3.initialize();
            return queue3;
        }
        if (destination.isTemporary()) {
            Topic topic = new Topic(this.brokerService, destination, null, destinationStatistics, this.taskRunnerFactory);
            this.configureTopic(topic, destination);
            topic.initialize();
            return topic;
        }
        TopicMessageStore store3 = null;
        if (!AdvisorySupport.isAdvisoryTopic(destination)) {
            store3 = this.persistenceAdapter.createTopicMessageStore((PMQTopic)destination);
        }
        Topic topic = new Topic(this.brokerService, destination, store3, destinationStatistics, this.taskRunnerFactory);
        this.configureTopic(topic, destination);
        topic.initialize();
        return topic;
    }

    @Override
    public void removeDestination(Destination dest) {
        PMQDestination destination = dest.getPMQDestination();
        if (!destination.isTemporary()) {
            if (destination.isQueue()) {
                this.persistenceAdapter.removeQueueMessageStore((PMQQueue)destination);
            } else if (!AdvisorySupport.isAdvisoryTopic(destination)) {
                this.persistenceAdapter.removeTopicMessageStore((PMQTopic)destination);
            }
        }
    }

    protected void configureQueue(Queue queue2, PMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure((Broker)this.broker, queue2);
        }
    }

    protected void configureTopic(Topic topic, PMQDestination destination) {
        PolicyEntry entry;
        if (this.broker == null) {
            throw new IllegalStateException("broker property is not set");
        }
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure((Broker)this.broker, topic);
        }
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.persistenceAdapter.getLastMessageBrokerSequenceId();
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.persistenceAdapter;
    }

    @Override
    public SubscriptionInfo[] getAllDurableSubscriptions(PMQTopic topic) throws IOException {
        return this.persistenceAdapter.createTopicMessageStore(topic).getAllSubscriptions();
    }
}

