/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.AbstractRegion;
import com.primeton.pmq.broker.region.DestinationFactory;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.QueueBrowserSubscription;
import com.primeton.pmq.broker.region.QueueSubscription;
import com.primeton.pmq.broker.region.RegionBroker;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.policy.PolicyEntry;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.MessageDispatchNotification;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.thread.TaskRunnerFactory;
import com.primeton.pmq.usage.SystemUsage;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;

public class QueueRegion
extends AbstractRegion {
    public QueueRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    public String toString() {
        return "QueueRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.usageManager.getMemoryUsage().getPercentUsage() + "%";
    }

    @Override
    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        PMQDestination destination = info.getDestination();
        PolicyEntry entry = null;
        if (destination != null && this.broker.getDestinationPolicy() != null) {
            entry = this.broker.getDestinationPolicy().getEntryFor(destination);
        }
        if (info.isBrowser()) {
            QueueBrowserSubscription sub = new QueueBrowserSubscription(this.broker, this.usageManager, context, info);
            if (entry != null) {
                entry.configure((Broker)this.broker, this.usageManager, sub);
            }
            return sub;
        }
        QueueSubscription sub = new QueueSubscription(this.broker, this.usageManager, context, info);
        if (entry != null) {
            entry.configure((Broker)this.broker, this.usageManager, sub);
        }
        return sub;
    }

    @Override
    protected Set<PMQDestination> getInactiveDestinations() {
        Set<PMQDestination> inactiveDestinations = super.getInactiveDestinations();
        Iterator<PMQDestination> iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            PMQDestination dest = iter.next();
            if (dest.isQueue()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        this.processDispatchNotificationViaDestination(messageDispatchNotification);
    }
}

