/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.IndirectMessageReference;
import com.primeton.pmq.broker.region.LockOwner;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.PrefetchSubscription;
import com.primeton.pmq.broker.region.Queue;
import com.primeton.pmq.broker.region.QueueMessageReference;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.usage.SystemUsage;
import java.io.IOException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueSubscription
extends PrefetchSubscription
implements LockOwner {
    private static final Logger LOG = LoggerFactory.getLogger(QueueSubscription.class);

    public QueueSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info) throws JMSException {
        super(broker, usageManager, context, info);
    }

    @Override
    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
        this.setTimeOfLastMessageAck(System.currentTimeMillis());
        Destination q = (Destination)n.getRegionDestination();
        QueueMessageReference node = (QueueMessageReference)n;
        Queue queue2 = (Queue)q;
        queue2.removeMessage(context, this, node, ack);
    }

    @Override
    protected boolean canDispatch(MessageReference n) throws IOException {
        boolean result = true;
        QueueMessageReference node = (QueueMessageReference)n;
        if (node.isAcked() || node.isDropped()) {
            result = false;
        }
        result = result && (this.isBrowser() || node.lock(this));
        return result;
    }

    public synchronized String toString() {
        return "QueueSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.prefetchExtension + ", pending=" + this.getPendingQueueSize() + ", prefetch=" + this.getPrefetchSize() + ", prefetchExtension=" + this.prefetchExtension.get();
    }

    @Override
    public int getLockPriority() {
        return this.info.getPriority();
    }

    @Override
    public boolean isLockExclusive() {
        return this.info.isExclusive();
    }

    @Override
    public void destroy() {
        this.setSlowConsumer(false);
    }

    @Override
    protected boolean isDropped(MessageReference node) {
        boolean result = false;
        if (node instanceof IndirectMessageReference) {
            QueueMessageReference qmr = (QueueMessageReference)node;
            result = qmr.isDropped();
        }
        return result;
    }
}

