/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerService;
import com.primeton.pmq.broker.Connection;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.ConsumerBrokerExchange;
import com.primeton.pmq.broker.EmptyBroker;
import com.primeton.pmq.broker.ProducerBrokerExchange;
import com.primeton.pmq.broker.TransportConnection;
import com.primeton.pmq.broker.TransportConnector;
import com.primeton.pmq.broker.region.BaseDestination;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.DestinationFactory;
import com.primeton.pmq.broker.region.DestinationInterceptor;
import com.primeton.pmq.broker.region.DestinationStatistics;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.QueueRegion;
import com.primeton.pmq.broker.region.Region;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.TempQueueRegion;
import com.primeton.pmq.broker.region.TempTopicRegion;
import com.primeton.pmq.broker.region.TopicRegion;
import com.primeton.pmq.broker.region.policy.DeadLetterStrategy;
import com.primeton.pmq.broker.region.policy.PolicyMap;
import com.primeton.pmq.command.BrokerId;
import com.primeton.pmq.command.BrokerInfo;
import com.primeton.pmq.command.ConnectionId;
import com.primeton.pmq.command.ConnectionInfo;
import com.primeton.pmq.command.ConsumerControl;
import com.primeton.pmq.command.ConsumerInfo;
import com.primeton.pmq.command.DestinationInfo;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.MessageAck;
import com.primeton.pmq.command.MessageDispatch;
import com.primeton.pmq.command.MessageDispatchNotification;
import com.primeton.pmq.command.MessagePull;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.ProducerInfo;
import com.primeton.pmq.command.RemoveSubscriptionInfo;
import com.primeton.pmq.command.Response;
import com.primeton.pmq.command.TransactionId;
import com.primeton.pmq.state.ConnectionState;
import com.primeton.pmq.store.PListStore;
import com.primeton.pmq.thread.Scheduler;
import com.primeton.pmq.thread.TaskRunnerFactory;
import com.primeton.pmq.transport.TransmitCallback;
import com.primeton.pmq.usage.SystemUsage;
import com.primeton.pmq.util.BrokerSupport;
import com.primeton.pmq.util.IdGenerator;
import com.primeton.pmq.util.InetAddressUtil;
import com.primeton.pmq.util.LongSequenceGenerator;
import com.primeton.pmq.util.ServiceStopper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionBroker
extends EmptyBroker {
    public static final String ORIGINAL_EXPIRATION = "originalExpiration";
    private static final Logger LOG = LoggerFactory.getLogger(RegionBroker.class);
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected DestinationFactory destinationFactory;
    protected final Map<ConnectionId, ConnectionState> connectionStates = Collections.synchronizedMap(new HashMap());
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    protected final BrokerService brokerService;
    private boolean started;
    private boolean keepDurableSubsActive;
    private final CopyOnWriteArrayList<Connection> connections = new CopyOnWriteArrayList();
    private final Map<PMQDestination, PMQDestination> destinationGate = new HashMap<PMQDestination, PMQDestination>();
    private final Map<PMQDestination, Destination> destinations = new ConcurrentHashMap<PMQDestination, Destination>();
    private final Map<BrokerId, BrokerInfo> brokerInfos = new HashMap<BrokerId, BrokerInfo>();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;
    private final Map<String, ConnectionContext> clientIdSet = new HashMap<String, ConnectionContext>();
    private final DestinationInterceptor destinationInterceptor;
    private ConnectionContext adminConnectionContext;
    private final Scheduler scheduler;
    private final ThreadPoolExecutor executor;
    private boolean allowTempAutoCreationOnSend;
    private final ReentrantReadWriteLock inactiveDestinationsPurgeLock = new ReentrantReadWriteLock();
    private final Runnable purgeInactiveDestinationsTask = new Runnable(){

        @Override
        public void run() {
            RegionBroker.this.purgeInactiveDestinations();
        }
    };

    public RegionBroker(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, SystemUsage memoryManager, DestinationFactory destinationFactory, DestinationInterceptor destinationInterceptor, Scheduler scheduler, ThreadPoolExecutor executor) throws IOException {
        this.brokerService = brokerService;
        this.executor = executor;
        this.scheduler = scheduler;
        if (destinationFactory == null) {
            throw new IllegalArgumentException("null destinationFactory");
        }
        this.sequenceGenerator.setLastSequenceId(destinationFactory.getLastMessageBrokerSequenceId());
        this.destinationFactory = destinationFactory;
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.destinationInterceptor = destinationInterceptor;
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public Map<PMQDestination, Destination> getDestinationMap() {
        HashMap<PMQDestination, Destination> answer = new HashMap<PMQDestination, Destination>(this.getQueueRegion().getDestinationMap());
        answer.putAll(this.getTopicRegion().getDestinationMap());
        return answer;
    }

    @Override
    public Map<PMQDestination, Destination> getDestinationMap(PMQDestination destination) {
        try {
            return this.getRegion(destination).getDestinationMap();
        }
        catch (JMSException jmse) {
            return Collections.emptyMap();
        }
    }

    @Override
    public Set<Destination> getDestinations(PMQDestination destination) {
        try {
            return this.getRegion(destination).getDestinations(destination);
        }
        catch (JMSException jmse) {
            return Collections.emptySet();
        }
    }

    public Region getQueueRegion() {
        return this.queueRegion;
    }

    public Region getTempQueueRegion() {
        return this.tempQueueRegion;
    }

    public Region getTempTopicRegion() {
        return this.tempTopicRegion;
    }

    public Region getTopicRegion() {
        return this.topicRegion;
    }

    protected Region createTempTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new QueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public void start() throws Exception {
        this.started = true;
        this.queueRegion.start();
        this.topicRegion.start();
        this.tempQueueRegion.start();
        this.tempTopicRegion.start();
        int period = this.brokerService.getSchedulePeriodForDestinationPurge();
        if (period > 0) {
            this.scheduler.executePeriodically(this.purgeInactiveDestinationsTask, period);
        }
    }

    @Override
    public void stop() throws Exception {
        this.started = false;
        this.scheduler.cancel(this.purgeInactiveDestinationsTask);
        ServiceStopper ss = new ServiceStopper();
        this.doStop(ss);
        ss.throwFirstException();
        this.clientIdSet.clear();
        this.connections.clear();
        this.destinations.clear();
        this.brokerInfos.clear();
    }

    public PolicyMap getDestinationPolicy() {
        return this.brokerService != null ? this.brokerService.getDestinationPolicy() : null;
    }

    public ConnectionContext getConnectionContext(String clientId) {
        return this.clientIdSet.get(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        ConnectionContext oldContext = null;
        Map<String, ConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            oldContext = this.clientIdSet.get(clientId);
            if (oldContext != null) {
                if (!context.isAllowLinkStealing()) throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + oldContext.getConnection().getRemoteAddress());
                this.clientIdSet.put(clientId, context);
            } else {
                this.clientIdSet.put(clientId, context);
            }
        }
        if (oldContext != null) {
            if (oldContext.getConnection() != null) {
                Connection connection = oldContext.getConnection();
                LOG.warn("Stealing link for clientId {} From Connection {}", (Object)clientId, (Object)oldContext.getConnection());
                if (connection instanceof TransportConnection) {
                    TransportConnection transportConnection = (TransportConnection)connection;
                    transportConnection.stopAsync(new IOException("Stealing link for clientId " + clientId + " From Connection " + oldContext.getConnection().getConnectionId()));
                } else {
                    connection.stop();
                }
            } else {
                LOG.error("No Connection found for {}", (Object)oldContext);
            }
        }
        this.connections.add(context.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection disconnect request");
        }
        Map<String, ConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            ConnectionContext oldValue = this.clientIdSet.get(clientId);
            if (oldValue == context && this.isEqual(oldValue.getConnectionId(), info.getConnectionId())) {
                this.clientIdSet.remove(clientId);
            }
        }
        this.connections.remove(context.getConnection());
    }

    protected boolean isEqual(ConnectionId connectionId, ConnectionId connectionId2) {
        return connectionId == connectionId2 || connectionId != null && connectionId.equals(connectionId2);
    }

    @Override
    public Connection[] getClients() throws Exception {
        ArrayList<Connection> l = new ArrayList<Connection>(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, PMQDestination destination, boolean createIfTemp) throws Exception {
        Destination answer = this.destinations.get(destination);
        if (answer != null) {
            return answer;
        }
        Map<PMQDestination, PMQDestination> map = this.destinationGate;
        synchronized (map) {
            answer = this.destinations.get(destination);
            if (answer != null) {
                return answer;
            }
            if (this.destinationGate.get(destination) != null) {
                while (this.destinationGate.containsKey(destination)) {
                    this.destinationGate.wait();
                }
                answer = this.destinations.get(destination);
                if (answer != null) {
                    return answer;
                }
                this.destinationGate.put(destination, destination);
            }
        }
        try {
            boolean create = true;
            if (destination.isTemporary()) {
                create = createIfTemp;
            }
            answer = this.getRegion(destination).addDestination(context, destination, create);
            this.destinations.put(destination, answer);
        }
        finally {
            Map<PMQDestination, PMQDestination> map2 = this.destinationGate;
            synchronized (map2) {
                this.destinationGate.remove(destination);
                this.destinationGate.notifyAll();
            }
        }
        return answer;
    }

    @Override
    public void removeDestination(ConnectionContext context, PMQDestination destination, long timeout) throws Exception {
        if (this.destinations.containsKey(destination)) {
            this.getRegion(destination).removeDestination(context, destination, timeout);
            this.destinations.remove(destination);
        }
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination(), true);
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.removeDestination(context, info.getDestination(), info.getTimeout());
    }

    @Override
    public PMQDestination[] getDestinations() throws Exception {
        ArrayList<PMQDestination> l = new ArrayList<PMQDestination>(this.getDestinationMap().keySet());
        PMQDestination[] rc = new PMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        PMQDestination destination = info.getDestination();
        if (destination != null) {
            this.inactiveDestinationsPurgeLock.readLock().lock();
            try {
                context.getBroker().addDestination(context, destination, this.isAllowTempAutoCreationOnSend());
                this.getRegion(destination).addProducer(context, info);
            }
            finally {
                this.inactiveDestinationsPurgeLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        PMQDestination destination = info.getDestination();
        if (destination != null) {
            this.inactiveDestinationsPurgeLock.readLock().lock();
            try {
                this.getRegion(destination).removeProducer(context, info);
            }
            finally {
                this.inactiveDestinationsPurgeLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        PMQDestination destination = info.getDestination();
        if (this.destinationInterceptor != null) {
            this.destinationInterceptor.create(this, context, destination);
        }
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            Subscription subscription = this.getRegion(destination).addConsumer(context, info);
            return subscription;
        }
        finally {
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        PMQDestination destination = info.getDestination();
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            this.getRegion(destination).removeConsumer(context, info);
        }
        finally {
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
    }

    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            this.topicRegion.removeSubscription(context, info);
        }
        finally {
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        PMQDestination destination = message.getDestination();
        message.setBrokerInTime(System.currentTimeMillis());
        if (producerExchange.isMutable() || producerExchange.getRegion() == null || producerExchange.getRegionDestination() != null && producerExchange.getRegionDestination().isDisposed()) {
            producerExchange.getConnectionContext().getBroker().addDestination(producerExchange.getConnectionContext(), destination, this.isAllowTempAutoCreationOnSend());
            producerExchange.setRegion(this.getRegion(destination));
            producerExchange.setRegionDestination(null);
        }
        producerExchange.getRegion().send(producerExchange, message);
        if (producerExchange.isMutable()) {
            producerExchange.setRegionDestination(null);
            producerExchange.setRegion(null);
        }
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        if (consumerExchange.isWildcard() || consumerExchange.getRegion() == null) {
            PMQDestination destination = ack.getDestination();
            consumerExchange.setRegion(this.getRegion(destination));
        }
        consumerExchange.getRegion().acknowledge(consumerExchange, ack);
    }

    public Region getRegion(PMQDestination destination) throws JMSException {
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion;
            }
            case 2: {
                return this.topicRegion;
            }
            case 5: {
                return this.tempQueueRegion;
            }
            case 6: {
                return this.tempTopicRegion;
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        PMQDestination destination = pull.getDestination();
        return this.getRegion(destination).messagePull(context, pull);
    }

    @Override
    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    @Override
    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    @Override
    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase(Locale.ENGLISH);
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected JMSException createUnknownDestinationTypeException(PMQDestination destination) {
        return new JMSException("Unknown destination type: " + destination.getDestinationType());
    }

    @Override
    public synchronized void addBroker(Connection connection, BrokerInfo info) {
        BrokerInfo existing = this.brokerInfos.get(info.getBrokerId());
        if (existing == null) {
            existing = info.copy();
            existing.setPeerBrokerInfos(null);
            this.brokerInfos.put(info.getBrokerId(), existing);
        }
        existing.incrementRefCount();
        LOG.debug("{} addBroker: {} brokerInfo size: {}", new Object[]{this.getBrokerName(), info.getBrokerName(), this.brokerInfos.size()});
        this.addBrokerInClusterUpdate(info);
    }

    @Override
    public synchronized void removeBroker(Connection connection, BrokerInfo info) {
        if (info != null) {
            BrokerInfo existing = this.brokerInfos.get(info.getBrokerId());
            if (existing != null && existing.decrementRefCount() == 0) {
                this.brokerInfos.remove(info.getBrokerId());
            }
            LOG.debug("{} removeBroker: {} brokerInfo size: {}", new Object[]{this.getBrokerName(), info.getBrokerName(), this.brokerInfos.size()});
            if (!this.brokerService.isStopping()) {
                this.removeBrokerInClusterUpdate(info);
            }
        }
    }

    @Override
    public synchronized BrokerInfo[] getPeerBrokerInfos() {
        BrokerInfo[] result = new BrokerInfo[this.brokerInfos.size()];
        result = this.brokerInfos.values().toArray(result);
        return result;
    }

    @Override
    public void preProcessDispatch(final MessageDispatch messageDispatch) {
        final Message message = messageDispatch.getMessage();
        if (message != null) {
            long endTime = System.currentTimeMillis();
            message.setBrokerOutTime(endTime);
            if (this.getBrokerService().isEnableStatistics()) {
                long totalTime = endTime - message.getBrokerInTime();
                ((Destination)message.getRegionDestination()).getDestinationStatistics().getProcessTime().addTime(totalTime);
            }
            if (((BaseDestination)message.getRegionDestination()).isPersistJMSRedelivered() && !message.isRedelivered()) {
                int originalValue = message.getRedeliveryCounter();
                message.incrementRedeliveryCounter();
                try {
                    if (message.isPersistent()) {
                        ((BaseDestination)message.getRegionDestination()).getMessageStore().updateMessage(message);
                    }
                    messageDispatch.setTransmitCallback(new TransmitCallback(){
                        final TransmitCallback delegate;
                        {
                            this.delegate = messageDispatch.getTransmitCallback();
                        }

                        @Override
                        public void onSuccess() {
                            message.incrementRedeliveryCounter();
                            if (this.delegate != null) {
                                this.delegate.onSuccess();
                            }
                        }

                        @Override
                        public void onFailure() {
                            if (this.delegate != null) {
                                this.delegate.onFailure();
                            }
                        }
                    });
                }
                catch (IOException error) {
                    RuntimeException runtimeException = new RuntimeException("Failed to persist JMSRedeliveryFlag on " + message.getMessageId() + " in " + message.getDestination(), error);
                    LOG.warn(runtimeException.getLocalizedMessage(), (Throwable)runtimeException);
                    throw runtimeException;
                }
                finally {
                    message.setRedeliveryCounter(originalValue);
                }
            }
        }
    }

    @Override
    public void postProcessDispatch(MessageDispatch messageDispatch) {
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        PMQDestination destination = messageDispatchNotification.getDestination();
        this.getRegion(destination).processDispatchNotification(messageDispatchNotification);
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public Set<PMQDestination> getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    protected void doStop(ServiceStopper ss) {
        ss.stop(this.queueRegion);
        ss.stop(this.topicRegion);
        ss.stop(this.tempQueueRegion);
        ss.stop(this.tempTopicRegion);
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
        ((TopicRegion)this.topicRegion).setKeepDurableSubsActive(keepDurableSubsActive);
    }

    public DestinationInterceptor getDestinationInterceptor() {
        return this.destinationInterceptor;
    }

    @Override
    public ConnectionContext getAdminConnectionContext() {
        return this.adminConnectionContext;
    }

    @Override
    public void setAdminConnectionContext(ConnectionContext adminConnectionContext) {
        this.adminConnectionContext = adminConnectionContext;
    }

    public Map<ConnectionId, ConnectionState> getConnectionStates() {
        return this.connectionStates;
    }

    @Override
    public PListStore getTempDataStore() {
        return this.brokerService.getTempDataStore();
    }

    @Override
    public URI getVmConnectorURI() {
        return this.brokerService.getVmConnectorURI();
    }

    @Override
    public void brokerServiceStarted() {
    }

    @Override
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public boolean isExpired(MessageReference messageReference) {
        return messageReference.canProcessAsExpired();
    }

    private boolean stampAsExpired(Message message) throws IOException {
        boolean stamped = false;
        if (message.getProperty(ORIGINAL_EXPIRATION) == null) {
            long expiration = message.getExpiration();
            message.setProperty(ORIGINAL_EXPIRATION, new Long(expiration));
            stamped = true;
        }
        return stamped;
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference node, Subscription subscription) {
        LOG.debug("Message expired {}", (Object)node);
        this.getRoot().sendToDeadLetterQueue(context, node, subscription, new Throwable("Message Expired. Expiration:" + node.getExpiration()));
    }

    @Override
    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference node, Subscription subscription, Throwable poisonCause) {
        try {
            Message message;
            if (node != null && (message = node.getMessage()) != null && node.getRegionDestination() != null) {
                DeadLetterStrategy deadLetterStrategy = ((Destination)node.getRegionDestination()).getDeadLetterStrategy();
                if (deadLetterStrategy != null) {
                    if (deadLetterStrategy.isSendToDeadLetterQueue(message)) {
                        PMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(message, subscription);
                        if (deadLetterDestination.equals(message.getDestination())) {
                            LOG.debug("Not re-adding to DLQ: {}, dest: {}", (Object)message.getMessageId(), (Object)message.getDestination());
                            return false;
                        }
                        message = message.copy();
                        long dlqExpiration = deadLetterStrategy.getExpiration();
                        if (dlqExpiration > 0L) {
                            dlqExpiration += System.currentTimeMillis();
                        } else {
                            this.stampAsExpired(message);
                        }
                        message.setExpiration(dlqExpiration);
                        if (!message.isPersistent()) {
                            message.setPersistent(true);
                            message.setProperty("originalDeliveryMode", "NON_PERSISTENT");
                        }
                        if (poisonCause != null) {
                            message.setProperty("dlqDeliveryFailureCause", poisonCause.toString());
                        }
                        ConnectionContext adminContext = context;
                        if (context.getSecurityContext() == null || !context.getSecurityContext().isBrokerContext()) {
                            adminContext = BrokerSupport.getConnectionContext(this);
                        }
                        this.addDestination(adminContext, deadLetterDestination, false).getPMQDestination().setDLQ(true);
                        BrokerSupport.resendNoCopy(adminContext, message, deadLetterDestination);
                        return true;
                    }
                } else {
                    LOG.debug("Dead Letter message with no DLQ strategy in place, message id: {}, destination: {}", (Object)message.getMessageId(), (Object)message.getDestination());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Caught an exception sending to DLQ: {}", (Object)node, (Object)e);
        }
        return false;
    }

    @Override
    public Broker getRoot() {
        try {
            return this.getBrokerService().getBroker();
        }
        catch (Exception e) {
            LOG.error("Trying to get Root Broker", (Throwable)e);
            throw new RuntimeException("The broker from the BrokerService should not throw an exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBrokerSequenceId() {
        LongSequenceGenerator longSequenceGenerator = this.sequenceGenerator;
        synchronized (longSequenceGenerator) {
            return this.sequenceGenerator.getNextSequenceId();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        PMQDestination destination = control.getDestination();
        try {
            this.getRegion(destination).processConsumerControl(consumerExchange, control);
        }
        catch (JMSException jmse) {
            LOG.warn("unmatched destination: {}, in consumerControl: {}", (Object)destination, (Object)control);
        }
    }

    protected void addBrokerInClusterUpdate(BrokerInfo info) {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients()) continue;
            connector.addPeerBroker(info);
            connector.updateClientClusterInfo();
        }
    }

    protected void removeBrokerInClusterUpdate(BrokerInfo info) {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients() || !connector.isUpdateClusterClientsOnRemove()) continue;
            connector.removePeerBroker(info);
            connector.updateClientClusterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeInactiveDestinations() {
        this.inactiveDestinationsPurgeLock.writeLock().lock();
        try {
            ArrayList<Destination> list = new ArrayList<Destination>();
            Map<PMQDestination, Destination> map = this.getDestinationMap();
            if (this.isAllowTempAutoCreationOnSend()) {
                map.putAll(this.tempQueueRegion.getDestinationMap());
                map.putAll(this.tempTopicRegion.getDestinationMap());
            }
            long maxPurgedDests = this.brokerService.getMaxPurgedDestinationsPerSweep();
            long timeStamp = System.currentTimeMillis();
            for (Destination d : map.values()) {
                d.markForGC(timeStamp);
                if (!d.canGC()) continue;
                list.add(d);
                if (maxPurgedDests <= 0L || (long)list.size() != maxPurgedDests) continue;
                break;
            }
            if (!list.isEmpty()) {
                ConnectionContext context = BrokerSupport.getConnectionContext(this);
                context.setBroker(this);
                for (Destination dest : list) {
                    Logger log2 = LOG;
                    if (dest instanceof BaseDestination) {
                        log2 = ((BaseDestination)dest).getLog();
                    }
                    log2.info("{} Inactive for longer than {} ms - removing ...", (Object)dest.getName(), (Object)dest.getInactiveTimeoutBeforeGC());
                    try {
                        this.getRoot().removeDestination(context, dest.getPMQDestination(), this.isAllowTempAutoCreationOnSend() ? 1L : 0L);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to remove inactive destination {}", (Object)dest, (Object)e);
                    }
                }
            }
        }
        finally {
            this.inactiveDestinationsPurgeLock.writeLock().unlock();
        }
    }

    public boolean isAllowTempAutoCreationOnSend() {
        return this.allowTempAutoCreationOnSend;
    }

    public void setAllowTempAutoCreationOnSend(boolean allowTempAutoCreationOnSend) {
        this.allowTempAutoCreationOnSend = allowTempAutoCreationOnSend;
    }

    @Override
    public void reapplyInterceptor() {
        this.queueRegion.reapplyInterceptor();
        this.topicRegion.reapplyInterceptor();
        this.tempQueueRegion.reapplyInterceptor();
        this.tempTopicRegion.reapplyInterceptor();
    }
}

