/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.policy;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.MessageReference;
import com.primeton.pmq.broker.region.SubscriptionRecovery;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.policy.SubscriptionRecoveryPolicy;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.DestinationFilter;
import java.util.ArrayList;

public class LastImageSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private volatile MessageReference lastImage;

    @Override
    public boolean add(ConnectionContext context, MessageReference node) throws Exception {
        this.lastImage = node;
        return true;
    }

    @Override
    public void recover(ConnectionContext context, Topic topic, SubscriptionRecovery sub) throws Exception {
        MessageReference node = this.lastImage;
        if (node != null) {
            sub.addRecoveredMessage(context, node);
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public Message[] browse(PMQDestination destination) throws Exception {
        DestinationFilter filter;
        ArrayList<Message> result = new ArrayList<Message>();
        if (this.lastImage != null && (filter = DestinationFilter.parseFilter(destination)).matches(this.lastImage.getMessage().getDestination())) {
            result.add(this.lastImage.getMessage());
        }
        return result.toArray(new Message[result.size()]);
    }

    @Override
    public SubscriptionRecoveryPolicy copy() {
        return new LastImageSubscriptionRecoveryPolicy();
    }

    @Override
    public void setBroker(Broker broker) {
    }
}

