/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.virtual;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.Subscription;
import com.primeton.pmq.broker.region.Topic;
import com.primeton.pmq.broker.region.virtual.VirtualTopic;
import com.primeton.pmq.broker.region.virtual.VirtualTopicInterceptor;
import com.primeton.pmq.command.Message;
import com.primeton.pmq.filter.BooleanExpression;
import com.primeton.pmq.filter.MessageEvaluationContext;
import com.primeton.pmq.filter.NonCachedMessageEvaluationContext;
import com.primeton.pmq.plugin.SubQueueSelectorCacheBroker;
import com.primeton.pmq.selector.SelectorParser;
import com.primeton.pmq.util.LRUCache;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorAwareVirtualTopicInterceptor
extends VirtualTopicInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorAwareVirtualTopicInterceptor.class);
    LRUCache<String, BooleanExpression> expressionCache = new LRUCache();
    private final SubQueueSelectorCacheBroker selectorCachePlugin;

    public SelectorAwareVirtualTopicInterceptor(Destination next, VirtualTopic virtualTopic) {
        super(next, virtualTopic);
        this.selectorCachePlugin = (SubQueueSelectorCacheBroker)((Topic)next).createConnectionContext().getBroker().getAdaptor(SubQueueSelectorCacheBroker.class);
    }

    @Override
    protected boolean shouldDispatch(Broker broker, Message message, Destination dest) throws IOException {
        if (super.shouldDispatch(broker, message, dest)) {
            boolean matches = false;
            NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
            msgContext.setDestination(dest.getPMQDestination());
            ((MessageEvaluationContext)msgContext).setMessageReference(message);
            List<Subscription> subs = dest.getConsumers();
            for (Subscription sub : subs) {
                if (!sub.matches(message, msgContext)) continue;
                matches = true;
                break;
            }
            if (!matches) {
                matches = this.tryMatchingCachedSubs(broker, dest, msgContext);
            }
            return matches;
        }
        return false;
    }

    private boolean tryMatchingCachedSubs(Broker broker, Destination dest, MessageEvaluationContext msgContext) {
        Set<String> selectors;
        boolean matches = false;
        LOG.debug("No active consumer match found. Will try cache if configured...");
        if (this.selectorCachePlugin != null && (selectors = this.selectorCachePlugin.getSelector(dest.getPMQDestination().getQualifiedName())) != null) {
            for (String selector : selectors) {
                try {
                    BooleanExpression expression = this.getExpression(selector);
                    matches = expression.matches(msgContext);
                    if (!matches) continue;
                    return true;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BooleanExpression getExpression(String selector) throws Exception {
        BooleanExpression result;
        LRUCache<String, BooleanExpression> lRUCache = this.expressionCache;
        synchronized (lRUCache) {
            result = (BooleanExpression)this.expressionCache.get(selector);
            if (result == null) {
                result = this.compileSelector(selector);
                this.expressionCache.put(selector, result);
            }
        }
        return result;
    }

    private BooleanExpression compileSelector(String selectorExpression) throws Exception {
        return SelectorParser.parse(selectorExpression);
    }
}

