/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.region.virtual;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.ConnectionContext;
import com.primeton.pmq.broker.region.Destination;
import com.primeton.pmq.broker.region.virtual.MappedQueueFilter;
import com.primeton.pmq.broker.region.virtual.SelectorAwareVirtualTopicInterceptor;
import com.primeton.pmq.broker.region.virtual.VirtualDestination;
import com.primeton.pmq.broker.region.virtual.VirtualTopicInterceptor;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import com.primeton.pmq.filter.DestinationFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VirtualTopic
implements VirtualDestination {
    private String prefix = "Consumer.*.";
    private String postfix = "";
    private String name = ">";
    private boolean selectorAware = false;
    private boolean local = false;
    private boolean concurrentSend = false;
    private boolean transactedSend = false;

    @Override
    public PMQDestination getVirtualDestination() {
        return new PMQTopic(this.getName());
    }

    @Override
    public Destination intercept(Destination destination) {
        return this.selectorAware ? new SelectorAwareVirtualTopicInterceptor(destination, this) : new VirtualTopicInterceptor(destination, this);
    }

    @Override
    public PMQDestination getMappedDestinations() {
        return new PMQQueue(this.prefix + this.name + this.postfix);
    }

    @Override
    public Destination interceptMappedDestination(Destination destination) {
        String physicalName = destination.getPMQDestination().getPhysicalName();
        Pattern pattern = Pattern.compile(this.getRegex(this.prefix) + "(.*)" + this.getRegex(this.postfix));
        Matcher matcher = pattern.matcher(physicalName);
        if (matcher.matches()) {
            String virtualName = matcher.group(1);
            return new MappedQueueFilter(new PMQTopic(virtualName), destination);
        }
        return destination;
    }

    private String getRegex(String part) {
        StringBuilder builder = new StringBuilder();
        block4: for (char c : part.toCharArray()) {
            switch (c) {
                case '.': {
                    builder.append("\\.");
                    continue block4;
                }
                case '*': {
                    builder.append("[^\\.]*");
                    continue block4;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    @Override
    public void create(Broker broker, ConnectionContext context, PMQDestination destination) throws Exception {
        DestinationFilter filter;
        if (destination.isQueue() && destination.isPattern() && (filter = DestinationFilter.parseFilter(new PMQQueue(this.prefix + ">"))).matches(destination)) {
            broker.addDestination(context, destination, false);
        }
    }

    @Override
    public void remove(Destination destination) {
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSelectorAware(boolean selectorAware) {
        this.selectorAware = selectorAware;
    }

    public boolean isSelectorAware() {
        return this.selectorAware;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String toString() {
        return "VirtualTopic:" + this.prefix + ',' + this.name + ',' + this.postfix + ',' + this.selectorAware + ',' + this.local;
    }

    public boolean isConcurrentSend() {
        return this.concurrentSend;
    }

    public void setConcurrentSend(boolean concurrentSend) {
        this.concurrentSend = concurrentSend;
    }

    public boolean isTransactedSend() {
        return this.transactedSend;
    }

    public void setTransactedSend(boolean transactedSend) {
        this.transactedSend = transactedSend;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.concurrentSend ? 1231 : 1237);
        result = 31 * result + (this.local ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.postfix == null ? 0 : this.postfix.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.selectorAware ? 1231 : 1237);
        result = 31 * result + (this.transactedSend ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualTopic other = (VirtualTopic)obj;
        if (this.concurrentSend != other.concurrentSend) {
            return false;
        }
        if (this.local != other.local) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.postfix == null ? other.postfix != null : !this.postfix.equals(other.postfix)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.selectorAware != other.selectorAware) {
            return false;
        }
        return this.transactedSend == other.transactedSend;
    }
}

