/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.broker.view;

import com.primeton.pmq.broker.Broker;
import com.primeton.pmq.broker.BrokerFilter;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DotFileInterceptorSupport
extends BrokerFilter {
    private final Logger log = LoggerFactory.getLogger(DotFileInterceptorSupport.class);
    private String file;

    public DotFileInterceptorSupport(Broker next, String file) {
        super(next);
        this.file = file;
    }

    protected void generateFile() throws Exception {
        this.log.debug("Creating DOT file at: {}", (Object)this.file);
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.file));){
            this.generateFile(writer);
        }
    }

    protected String quoteWrapId(String id) {
        return "\"" + id + "\"";
    }

    protected abstract void generateFile(PrintWriter var1) throws Exception;
}

