/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.component;

import com.primeton.pmq.advisory.DestinationEvent;
import com.primeton.pmq.advisory.DestinationListener;
import com.primeton.pmq.advisory.DestinationSource;
import com.primeton.pmq.camel.component.PMQComponent;
import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.command.PMQQueue;
import com.primeton.pmq.command.PMQTopic;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEndpointLoader
implements CamelContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelEndpointLoader.class);
    private CamelContext camelContext;
    private PMQComponent component;
    DestinationSource source;

    public CamelEndpointLoader() {
    }

    public CamelEndpointLoader(CamelContext camelContext, DestinationSource source) {
        this.camelContext = camelContext;
        this.source = source;
    }

    @PostConstruct
    private void postConstruct() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.source != null) {
            this.source.setDestinationListener(new DestinationListener(){

                @Override
                public void onDestinationEvent(DestinationEvent event) {
                    try {
                        PMQDestination destination = event.getDestination();
                        if (destination instanceof PMQQueue) {
                            PMQQueue queue2 = (PMQQueue)destination;
                            if (event.isAddOperation()) {
                                CamelEndpointLoader.this.addQueue(queue2);
                            } else {
                                CamelEndpointLoader.this.removeQueue(queue2);
                            }
                        } else if (destination instanceof PMQTopic) {
                            PMQTopic topic = (PMQTopic)destination;
                            if (event.isAddOperation()) {
                                CamelEndpointLoader.this.addTopic(topic);
                            } else {
                                CamelEndpointLoader.this.removeTopic(topic);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Caught: " + e, (Throwable)e);
                    }
                }
            });
            Set<PMQQueue> queues = this.source.getQueues();
            for (PMQQueue queue2 : queues) {
                this.addQueue(queue2);
            }
            Set<PMQTopic> topics = this.source.getTopics();
            for (PMQTopic topic : topics) {
                this.addTopic(topic);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public PMQComponent getComponent() {
        if (this.component == null) {
            this.component = (PMQComponent)this.camelContext.getComponent("pmq", PMQComponent.class);
        }
        return this.component;
    }

    public void setComponent(PMQComponent component) {
        this.component = component;
    }

    protected void addQueue(PMQQueue queue2) throws Exception {
        String queueUri = this.getQueueUri(queue2);
        PMQComponent jmsComponent = this.getComponent();
        JmsQueueEndpoint endpoint = new JmsQueueEndpoint(queueUri, (JmsComponent)jmsComponent, queue2.getPhysicalName(), jmsComponent.getConfiguration());
        this.camelContext.addEndpoint(queueUri, (Endpoint)endpoint);
    }

    protected String getQueueUri(PMQQueue queue2) {
        return "pmq:" + queue2.getPhysicalName();
    }

    protected void removeQueue(PMQQueue queue2) throws Exception {
        String queueUri = this.getQueueUri(queue2);
        this.camelContext.removeEndpoints(queueUri);
    }

    protected void addTopic(PMQTopic topic) throws Exception {
        String topicUri = this.getTopicUri(topic);
        PMQComponent jmsComponent = this.getComponent();
        JmsEndpoint endpoint = new JmsEndpoint(topicUri, (JmsComponent)jmsComponent, topic.getPhysicalName(), true, jmsComponent.getConfiguration());
        this.camelContext.addEndpoint(topicUri, (Endpoint)endpoint);
    }

    protected String getTopicUri(PMQTopic topic) {
        return "pmq:topic:" + topic.getPhysicalName();
    }

    protected void removeTopic(PMQTopic topic) throws Exception {
        String topicUri = this.getTopicUri(topic);
        this.camelContext.removeEndpoints(topicUri);
    }
}

