/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.camel.component.broker;

import com.primeton.pmq.broker.view.MessageBrokerView;
import com.primeton.pmq.broker.view.MessageBrokerViewRegistry;
import com.primeton.pmq.camel.component.broker.BrokerConfiguration;
import com.primeton.pmq.camel.component.broker.BrokerEndpoint;
import com.primeton.pmq.command.PMQDestination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.util.ObjectHelper;

public class BrokerComponent
extends UriEndpointComponent
implements EndpointCompleter {
    public BrokerComponent() {
        super(BrokerEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BrokerConfiguration brokerConfiguration = new BrokerConfiguration();
        this.setProperties(brokerConfiguration, parameters);
        int destinationType = 1;
        if (remaining.startsWith("queue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
        } else if (remaining.startsWith("topic:")) {
            destinationType = 2;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
        } else if (remaining.startsWith("temp-queue:")) {
            destinationType = 5;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp-queue:".length()), (char)'/');
        } else if (remaining.startsWith("temp-topic:")) {
            destinationType = 6;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp-topic:".length()), (char)'/');
        }
        PMQDestination destination = PMQDestination.createDestination(remaining, (byte)destinationType);
        BrokerEndpoint brokerEndpoint = new BrokerEndpoint(uri, this, remaining, destination, brokerConfiguration);
        this.setProperties((Object)brokerEndpoint, parameters);
        return brokerEndpoint;
    }

    public List<String> completeEndpointPath(ComponentConfiguration componentConfiguration, String completionText) {
        String brokerName = String.valueOf(componentConfiguration.getParameter("brokerName"));
        MessageBrokerView messageBrokerView = MessageBrokerViewRegistry.getInstance().lookup(brokerName);
        if (messageBrokerView != null) {
            String destinationName = completionText;
            Set<PMQDestination> set = messageBrokerView.getQueues();
            if (completionText.startsWith("topic:")) {
                set = messageBrokerView.getTopics();
                destinationName = completionText.substring(6);
            } else if (completionText.startsWith("queue:")) {
                destinationName = completionText.substring(6);
            }
            ArrayList<String> answer = new ArrayList<String>();
            for (PMQDestination destination : set) {
                if (!destination.getPhysicalName().startsWith(destinationName)) continue;
                answer.add(destination.getPhysicalName());
            }
            return answer;
        }
        return null;
    }
}

