/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class Main {
    public static final String TASK_DEFAULT_CLASS = "com.primeton.pmq.console.command.ShellCommand";
    private static boolean useDefExt = true;
    private File pmqHome;
    private File pmqBase;
    private ClassLoader classLoader;
    private final Set<File> extensions = new LinkedHashSet<File>();
    private final Set<File> pmqClassPath = new LinkedHashSet<File>();

    public static void main(String[] args) {
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpdir.exists()) {
            tmpdir.mkdirs();
        }
        Main app = new Main();
        LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(args));
        app.parseExtensions(tokens);
        File confDir = app.getPMQConfig();
        app.addClassPath(confDir);
        if (useDefExt && app.canUseExtdir()) {
            boolean baseIsHome = app.getPMQBase().equals(app.getPMQHome());
            File baseLibDir = new File(app.getPMQBase(), "lib");
            File homeLibDir = new File(app.getPMQHome(), "lib");
            if (!baseIsHome) {
                app.addExtensionDirectory(baseLibDir);
            }
            app.addExtensionDirectory(homeLibDir);
            if (!baseIsHome) {
                app.addExtensionDirectory(new File(baseLibDir, "camel"));
                app.addExtensionDirectory(new File(baseLibDir, "optional"));
                app.addExtensionDirectory(new File(baseLibDir, "web"));
                app.addExtensionDirectory(new File(baseLibDir, "extra"));
            }
            app.addExtensionDirectory(new File(homeLibDir, "camel"));
            app.addExtensionDirectory(new File(homeLibDir, "optional"));
            app.addExtensionDirectory(new File(homeLibDir, "web"));
            app.addExtensionDirectory(new File(homeLibDir, "extra"));
        }
        app.addClassPathList(System.getProperty("pmq.classpath"));
        try {
            int ret = app.runTaskClass(tokens);
            System.exit(ret);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not load class: " + e.getMessage());
            try {
                ClassLoader cl = app.getClassLoader();
                if (cl != null) {
                    System.out.println("Class loader setup: ");
                    Main.printClassLoaderTree(cl);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            System.exit(1);
        }
        catch (Throwable e) {
            System.out.println("Failed to execute main task. Reason: " + e);
            System.exit(1);
        }
    }

    private static int printClassLoaderTree(ClassLoader cl) {
        int depth = 0;
        if (cl.getParent() != null) {
            depth = Main.printClassLoaderTree(cl.getParent()) + 1;
        }
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            indent.append("  ");
        }
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            System.out.println(indent + cl.getClass().getName() + " {");
            URL[] urls = ucl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                System.out.println(indent + "  " + urls[i]);
            }
            System.out.println(indent + "}");
        } else {
            System.out.println(indent + cl.getClass().getName());
        }
        return depth;
    }

    public void parseExtensions(List<String> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        int count = tokens.size();
        int i = 0;
        while (i < count) {
            String token = tokens.get(i);
            if (token.equals("--extdir")) {
                tokens.remove(i);
                if (i >= --count || tokens.get(i).startsWith("-")) {
                    System.out.println("Extension directory not specified.");
                    System.out.println("Ignoring extension directory option.");
                    continue;
                }
                --count;
                File extDir = new File(tokens.remove(i));
                if (!this.canUseExtdir()) {
                    System.out.println("Extension directory feature not available due to the system classpath being able to load: com.primeton.pmq.console.command.ShellCommand");
                    System.out.println("Ignoring extension directory option.");
                    continue;
                }
                if (!extDir.isDirectory()) {
                    System.out.println("Extension directory specified is not valid directory: " + extDir);
                    System.out.println("Ignoring extension directory option.");
                    continue;
                }
                this.addExtensionDirectory(extDir);
                continue;
            }
            if (token.equals("--noDefExt")) {
                --count;
                tokens.remove(i);
                useDefExt = false;
                continue;
            }
            ++i;
        }
    }

    public int runTaskClass(List<String> tokens) throws Throwable {
        StringBuilder buffer = new StringBuilder();
        buffer.append(System.getProperty("java.vendor"));
        buffer.append(" ");
        buffer.append(System.getProperty("java.version"));
        buffer.append(" ");
        buffer.append(System.getProperty("java.home"));
        System.out.println("Java Runtime: " + buffer.toString());
        buffer = new StringBuilder();
        buffer.append("current=");
        buffer.append(Runtime.getRuntime().totalMemory() / 1024L);
        buffer.append("k  free=");
        buffer.append(Runtime.getRuntime().freeMemory() / 1024L);
        buffer.append("k  max=");
        buffer.append(Runtime.getRuntime().maxMemory() / 1024L);
        buffer.append("k");
        System.out.println("  Heap sizes: " + buffer.toString());
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        buffer = new StringBuilder();
        for (String arg : jvmArgs) {
            buffer.append(" ").append((Object)arg);
        }
        System.out.println("    JVM args:" + buffer.toString());
        System.out.println("Extensions classpath:\n  " + this.getExtensionDirForLogging());
        System.out.println("PMQ_HOME: " + this.getPMQHome());
        System.out.println("PMQ_BASE: " + this.getPMQBase());
        System.out.println("PMQ_CONF: " + this.getPMQConfig());
        System.out.println("PMQ_DATA: " + this.getPMQDataDir());
        ClassLoader cl = this.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            String[] args = tokens.toArray(new String[tokens.size()]);
            Class<?> task = cl.loadClass(TASK_DEFAULT_CLASS);
            Method runTask = task.getMethod("main", String[].class, InputStream.class, PrintStream.class);
            return (Integer)runTask.invoke(task.newInstance(), args, System.in, System.out);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void addExtensionDirectory(File directory) {
        this.extensions.add(directory);
    }

    public void addClassPathList(String fileList) {
        if (fileList != null && fileList.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(fileList, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                this.addClassPath(new File(tokenizer.nextToken()));
            }
        }
    }

    public void addClassPath(File classpath) {
        this.pmqClassPath.add(classpath);
    }

    public boolean canUseExtdir() {
        try {
            Main.class.getClassLoader().loadClass(TASK_DEFAULT_CLASS);
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classLoader == null) {
            this.classLoader = Main.class.getClassLoader();
            if (!this.extensions.isEmpty() || !this.pmqClassPath.isEmpty()) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (File dir : this.pmqClassPath) {
                    urls.add(dir.toURI().toURL());
                }
                for (File dir : this.extensions) {
                    File[] files;
                    if (!dir.isDirectory() || (files = dir.listFiles()) == null) continue;
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File f1, File f2) {
                            return f1.getName().compareTo(f2.getName());
                        }
                    });
                    for (int j = 0; j < files.length; ++j) {
                        if (!files[j].getName().endsWith(".zip") && !files[j].getName().endsWith(".jar")) continue;
                        urls.add(files[j].toURI().toURL());
                    }
                }
                URL[] u = new URL[urls.size()];
                urls.toArray(u);
                this.classLoader = new URLClassLoader(u, this.classLoader);
            }
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        return this.classLoader;
    }

    public void setPMQHome(File pmqHome) {
        this.pmqHome = pmqHome;
    }

    public File getPMQHome() {
        if (this.pmqHome == null) {
            URL url;
            if (System.getProperty("pmq.home") != null) {
                this.pmqHome = new File(System.getProperty("pmq.home"));
            }
            if (this.pmqHome == null && (url = Main.class.getClassLoader().getResource("com/primeton/pmq/console/Main.class")) != null) {
                try {
                    JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                    url = jarConnection.getJarFileURL();
                    URI baseURI = new URI(url.toString()).resolve("..");
                    this.pmqHome = new File(baseURI).getCanonicalFile();
                    System.setProperty("pmq.home", this.pmqHome.getAbsolutePath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.pmqHome == null) {
                this.pmqHome = new File("../.");
                System.setProperty("pmq.home", this.pmqHome.getAbsolutePath());
            }
        }
        return this.pmqHome;
    }

    public File getPMQBase() {
        if (this.pmqBase == null) {
            if (System.getProperty("pmq.base") != null) {
                this.pmqBase = new File(System.getProperty("pmq.base"));
            }
            if (this.pmqBase == null) {
                this.pmqBase = this.getPMQHome();
                System.setProperty("pmq.base", this.pmqBase.getAbsolutePath());
            }
        }
        return this.pmqBase;
    }

    public File getPMQConfig() {
        File pmqConfig = null;
        if (System.getProperty("pmq.conf") != null) {
            pmqConfig = new File(System.getProperty("pmq.conf"));
        } else {
            pmqConfig = new File(this.getPMQBase() + "/conf");
            System.setProperty("pmq.conf", pmqConfig.getAbsolutePath());
        }
        return pmqConfig;
    }

    public File getPMQLicense() {
        File pmqConfig = null;
        if (System.getProperty("pmq.license") != null) {
            pmqConfig = new File(System.getProperty("pmq.license"));
        } else {
            pmqConfig = new File(this.getPMQBase() + "/license");
            System.setProperty("pmq.license", pmqConfig.getAbsolutePath());
        }
        return pmqConfig;
    }

    public File getPMQDataDir() {
        File pmqDataDir = null;
        if (System.getProperty("pmq.data") != null) {
            pmqDataDir = new File(System.getProperty("pmq.data"));
        } else {
            pmqDataDir = new File(this.getPMQBase() + "/data");
            System.setProperty("pmq.data", pmqDataDir.getAbsolutePath());
        }
        return pmqDataDir;
    }

    public String getExtensionDirForLogging() {
        StringBuilder sb = new StringBuilder("[");
        Iterator<File> it = this.extensions.iterator();
        while (it.hasNext()) {
            File file = it.next();
            sb.append(file.getPath());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

