/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.command;

import com.primeton.pmq.console.command.EncryptCommand;
import java.util.List;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

public class DecryptCommand
extends EncryptCommand {
    protected String[] helpFile = new String[]{"Task Usage: Main decrypt --password <password> --input <input>", "Description: Decrypts given text.", "", "Encrypt Options:", "    --password <password>      Password to be used by the encryptor.  Defaults to", "                               the value in the PMQ_ENCRYPTION_PASSWORD env variable.", "    --input <input>            Text to be encrypted.", "    --version                  Display the version information.", "    -h,-?,--help               Display the stop broker help information.", ""};

    @Override
    public String getName() {
        return "decrypt";
    }

    @Override
    public String getOneLineDescription() {
        return "Decrypts given text";
    }

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        if (this.password == null) {
            this.password = System.getenv("PMQ_ENCRYPTION_PASSWORD");
        }
        if (this.password == null || this.input == null) {
            this.context.printException(new IllegalArgumentException("input and password parameters are mandatory"));
            return;
        }
        this.encryptor.setPassword(this.password);
        try {
            this.context.print("Decrypted text: " + this.encryptor.decrypt(this.input));
        }
        catch (EncryptionOperationNotPossibleException e) {
            this.context.print("ERROR: Text cannot be decrypted, check your input and password and try again!");
        }
    }
}

