/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.console.command.store;

import com.primeton.pmq.console.command.store.proto.MapEntryPB;
import com.primeton.pmq.console.command.store.proto.MessagePB;
import com.primeton.pmq.console.command.store.proto.QueueEntryPB;
import com.primeton.pmq.console.command.store.proto.QueuePB;
import com.primeton.pmq.console.command.store.tar.TarEntry;
import com.primeton.pmq.console.command.store.tar.TarOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.MessageBuffer;

public class ExportStreamManager {
    private final OutputStream target;
    private final int version;
    TarOutputStream stream;
    long seq = 0L;

    ExportStreamManager(OutputStream target, int version) throws IOException {
        this.target = target;
        this.version = version;
        this.stream = new TarOutputStream(new GZIPOutputStream(target));
        this.store("ver", new AsciiBuffer("" + version));
    }

    public void finish() throws IOException {
        this.stream.close();
    }

    private void store(String ext, Buffer value) throws IOException {
        TarEntry entry = new TarEntry(this.seq + "." + ext);
        ++this.seq;
        entry.setSize(value.length());
        this.stream.putNextEntry(entry);
        value.writeTo(this.stream);
        this.stream.closeEntry();
    }

    private void store(String ext, MessageBuffer<?, ?> value) throws IOException {
        TarEntry entry = new TarEntry(this.seq + "." + ext);
        ++this.seq;
        entry.setSize(value.serializedSizeFramed());
        this.stream.putNextEntry(entry);
        value.writeFramed((OutputStream)this.stream);
        this.stream.closeEntry();
    }

    public void store_queue(QueuePB.Getter value) throws IOException {
        this.store("que", value.freeze());
    }

    public void store_queue_entry(QueueEntryPB.Getter value) throws IOException {
        this.store("qen", value.freeze());
    }

    public void store_message(MessagePB.Getter value) throws IOException {
        this.store("msg", value.freeze());
    }

    public void store_map_entry(MapEntryPB.Getter value) throws IOException {
        this.store("map", value.freeze());
    }
}

