/*
 * Decompiled with CFR 0.152.
 */
package com.primeton.pmq.filter;

import com.primeton.pmq.command.PMQDestination;
import com.primeton.pmq.filter.BooleanExpression;
import com.primeton.pmq.filter.CompositeDestinationFilter;
import com.primeton.pmq.filter.DestinationPath;
import com.primeton.pmq.filter.MessageEvaluationContext;
import com.primeton.pmq.filter.PrefixDestinationFilter;
import com.primeton.pmq.filter.SimpleDestinationFilter;
import com.primeton.pmq.filter.WildcardDestinationFilter;
import com.primeton.pmq.util.JMSExceptionSupport;
import java.io.IOException;
import javax.jms.JMSException;

public abstract class DestinationFilter
implements BooleanExpression {
    public static final String ANY_DESCENDENT = ">";
    public static final String ANY_CHILD = "*";

    @Override
    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean matches(MessageEvaluationContext message) throws JMSException {
        try {
            if (message.isDropped()) {
                return false;
            }
            return this.matches(message.getMessage().getDestination());
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public abstract boolean matches(PMQDestination var1);

    public static DestinationFilter parseFilter(PMQDestination destination) {
        if (destination.isComposite()) {
            return new CompositeDestinationFilter(destination);
        }
        String[] paths = DestinationPath.getDestinationPaths(destination);
        int idx = paths.length - 1;
        if (idx >= 0) {
            String lastPath = paths[idx];
            if (lastPath.equals(ANY_DESCENDENT)) {
                return new PrefixDestinationFilter(paths, destination.getDestinationType());
            }
            while (idx >= 0) {
                if (!(lastPath = paths[idx--]).equals(ANY_CHILD)) continue;
                return new WildcardDestinationFilter(paths, destination.getDestinationType());
            }
        }
        return new SimpleDestinationFilter(destination);
    }

    public abstract boolean isWildcard();
}

